@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderForServersAwsOfferingVmScannersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The Microsoft Defender for Server VM scanning configuration
 * @property configuration configuration for Microsoft Defender for Server VM scanning
 * @property enabled Is Microsoft Defender for Server VM scanning enabled
 */
public data class DefenderForServersAwsOfferingVmScannersArgs(
    public val configuration:
    Output<DefenderForServersAwsOfferingConfigurationConfigurationConfigurationArgs>? = null,
    public val enabled: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderForServersAwsOfferingVmScannersArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.DefenderForServersAwsOfferingVmScannersArgs =
        com.pulumi.azurenative.security.inputs.DefenderForServersAwsOfferingVmScannersArgs.builder()
            .configuration(configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefenderForServersAwsOfferingVmScannersArgs].
 */
@PulumiTagMarker
public class DefenderForServersAwsOfferingVmScannersArgsBuilder internal constructor() {
    private var configuration:
        Output<DefenderForServersAwsOfferingConfigurationConfigurationConfigurationArgs>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value configuration for Microsoft Defender for Server VM scanning
     */
    @JvmName("ibsmvpwsiouycxkg")
    public suspend
    fun configuration(`value`: Output<DefenderForServersAwsOfferingConfigurationConfigurationConfigurationArgs>) {
        this.configuration = value
    }

    /**
     * @param value Is Microsoft Defender for Server VM scanning enabled
     */
    @JvmName("mbeanenmqtufilxb")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value configuration for Microsoft Defender for Server VM scanning
     */
    @JvmName("hirybrjopidpptxc")
    public suspend
    fun configuration(`value`: DefenderForServersAwsOfferingConfigurationConfigurationConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument configuration for Microsoft Defender for Server VM scanning
     */
    @JvmName("lqwqtexmpvyoxlme")
    public suspend
    fun configuration(argument: suspend DefenderForServersAwsOfferingConfigurationConfigurationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            DefenderForServersAwsOfferingConfigurationConfigurationConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value Is Microsoft Defender for Server VM scanning enabled
     */
    @JvmName("fibhasblckslavpq")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): DefenderForServersAwsOfferingVmScannersArgs =
        DefenderForServersAwsOfferingVmScannersArgs(
            configuration = configuration,
            enabled = enabled,
        )
}
