@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderForServersGcpOfferingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The Defender for Servers GCP offering configurations
 * @property arcAutoProvisioning The ARC autoprovisioning configuration
 * @property defenderForServers The Defender for servers connection configuration
 * @property mdeAutoProvisioning The Microsoft Defender for Endpoint autoprovisioning configuration
 * @property offeringType The type of the security offering.
 * Expected value is 'DefenderForServersGcp'.
 * @property subPlan configuration for the servers offering subPlan
 * @property vaAutoProvisioning The Vulnerability Assessment autoprovisioning configuration
 * @property vmScanners The Microsoft Defender for Server VM scanning configuration
 */
public data class DefenderForServersGcpOfferingArgs(
    public val arcAutoProvisioning: Output<DefenderForServersGcpOfferingArcAutoProvisioningArgs>? =
        null,
    public val defenderForServers: Output<DefenderForServersGcpOfferingDefenderForServersArgs>? =
        null,
    public val mdeAutoProvisioning: Output<DefenderForServersGcpOfferingMdeAutoProvisioningArgs>? =
        null,
    public val offeringType: Output<String>,
    public val subPlan: Output<DefenderForServersGcpOfferingSubPlanArgs>? = null,
    public val vaAutoProvisioning: Output<DefenderForServersGcpOfferingVaAutoProvisioningArgs>? =
        null,
    public val vmScanners: Output<DefenderForServersGcpOfferingVmScannersArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderForServersGcpOfferingArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.DefenderForServersGcpOfferingArgs =
        com.pulumi.azurenative.security.inputs.DefenderForServersGcpOfferingArgs.builder()
            .arcAutoProvisioning(
                arcAutoProvisioning?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .defenderForServers(
                defenderForServers?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .mdeAutoProvisioning(
                mdeAutoProvisioning?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .offeringType(offeringType.applyValue({ args0 -> args0 }))
            .subPlan(subPlan?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vaAutoProvisioning(
                vaAutoProvisioning?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .vmScanners(vmScanners?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DefenderForServersGcpOfferingArgs].
 */
@PulumiTagMarker
public class DefenderForServersGcpOfferingArgsBuilder internal constructor() {
    private var arcAutoProvisioning: Output<DefenderForServersGcpOfferingArcAutoProvisioningArgs>? =
        null

    private var defenderForServers: Output<DefenderForServersGcpOfferingDefenderForServersArgs>? =
        null

    private var mdeAutoProvisioning: Output<DefenderForServersGcpOfferingMdeAutoProvisioningArgs>? =
        null

    private var offeringType: Output<String>? = null

    private var subPlan: Output<DefenderForServersGcpOfferingSubPlanArgs>? = null

    private var vaAutoProvisioning: Output<DefenderForServersGcpOfferingVaAutoProvisioningArgs>? =
        null

    private var vmScanners: Output<DefenderForServersGcpOfferingVmScannersArgs>? = null

    /**
     * @param value The ARC autoprovisioning configuration
     */
    @JvmName("gmlevsrypfkaypea")
    public suspend
    fun arcAutoProvisioning(`value`: Output<DefenderForServersGcpOfferingArcAutoProvisioningArgs>) {
        this.arcAutoProvisioning = value
    }

    /**
     * @param value The Defender for servers connection configuration
     */
    @JvmName("oymjvmggrhqdxjoi")
    public suspend
    fun defenderForServers(`value`: Output<DefenderForServersGcpOfferingDefenderForServersArgs>) {
        this.defenderForServers = value
    }

    /**
     * @param value The Microsoft Defender for Endpoint autoprovisioning configuration
     */
    @JvmName("wnjqqudueohnleon")
    public suspend
    fun mdeAutoProvisioning(`value`: Output<DefenderForServersGcpOfferingMdeAutoProvisioningArgs>) {
        this.mdeAutoProvisioning = value
    }

    /**
     * @param value The type of the security offering.
     * Expected value is 'DefenderForServersGcp'.
     */
    @JvmName("syrppamlwddegkoj")
    public suspend fun offeringType(`value`: Output<String>) {
        this.offeringType = value
    }

    /**
     * @param value configuration for the servers offering subPlan
     */
    @JvmName("uvrduipucssxxqtg")
    public suspend fun subPlan(`value`: Output<DefenderForServersGcpOfferingSubPlanArgs>) {
        this.subPlan = value
    }

    /**
     * @param value The Vulnerability Assessment autoprovisioning configuration
     */
    @JvmName("msymwdjuanfogpay")
    public suspend
    fun vaAutoProvisioning(`value`: Output<DefenderForServersGcpOfferingVaAutoProvisioningArgs>) {
        this.vaAutoProvisioning = value
    }

    /**
     * @param value The Microsoft Defender for Server VM scanning configuration
     */
    @JvmName("joqensbnbijeaina")
    public suspend fun vmScanners(`value`: Output<DefenderForServersGcpOfferingVmScannersArgs>) {
        this.vmScanners = value
    }

    /**
     * @param value The ARC autoprovisioning configuration
     */
    @JvmName("rvfqqhjaseeycwey")
    public suspend
    fun arcAutoProvisioning(`value`: DefenderForServersGcpOfferingArcAutoProvisioningArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arcAutoProvisioning = mapped
    }

    /**
     * @param argument The ARC autoprovisioning configuration
     */
    @JvmName("juneyfsxvngjnlto")
    public suspend
    fun arcAutoProvisioning(argument: suspend DefenderForServersGcpOfferingArcAutoProvisioningArgsBuilder.() -> Unit) {
        val toBeMapped = DefenderForServersGcpOfferingArcAutoProvisioningArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.arcAutoProvisioning = mapped
    }

    /**
     * @param value The Defender for servers connection configuration
     */
    @JvmName("pfruhrhvvmnfuqnr")
    public suspend
    fun defenderForServers(`value`: DefenderForServersGcpOfferingDefenderForServersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defenderForServers = mapped
    }

    /**
     * @param argument The Defender for servers connection configuration
     */
    @JvmName("jgxojuoqsfissmxq")
    public suspend
    fun defenderForServers(argument: suspend DefenderForServersGcpOfferingDefenderForServersArgsBuilder.() -> Unit) {
        val toBeMapped = DefenderForServersGcpOfferingDefenderForServersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.defenderForServers = mapped
    }

    /**
     * @param value The Microsoft Defender for Endpoint autoprovisioning configuration
     */
    @JvmName("kxgooftostbtbmcl")
    public suspend
    fun mdeAutoProvisioning(`value`: DefenderForServersGcpOfferingMdeAutoProvisioningArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mdeAutoProvisioning = mapped
    }

    /**
     * @param argument The Microsoft Defender for Endpoint autoprovisioning configuration
     */
    @JvmName("pcfrgqsndotbbpen")
    public suspend
    fun mdeAutoProvisioning(argument: suspend DefenderForServersGcpOfferingMdeAutoProvisioningArgsBuilder.() -> Unit) {
        val toBeMapped = DefenderForServersGcpOfferingMdeAutoProvisioningArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.mdeAutoProvisioning = mapped
    }

    /**
     * @param value The type of the security offering.
     * Expected value is 'DefenderForServersGcp'.
     */
    @JvmName("ukjadvfthkojcoae")
    public suspend fun offeringType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offeringType = mapped
    }

    /**
     * @param value configuration for the servers offering subPlan
     */
    @JvmName("bawbgbgqnwffxrti")
    public suspend fun subPlan(`value`: DefenderForServersGcpOfferingSubPlanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subPlan = mapped
    }

    /**
     * @param argument configuration for the servers offering subPlan
     */
    @JvmName("ehngenmubkqlfkpe")
    public suspend
    fun subPlan(argument: suspend DefenderForServersGcpOfferingSubPlanArgsBuilder.() -> Unit) {
        val toBeMapped = DefenderForServersGcpOfferingSubPlanArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.subPlan = mapped
    }

    /**
     * @param value The Vulnerability Assessment autoprovisioning configuration
     */
    @JvmName("ivqdaapysncynvuo")
    public suspend
    fun vaAutoProvisioning(`value`: DefenderForServersGcpOfferingVaAutoProvisioningArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaAutoProvisioning = mapped
    }

    /**
     * @param argument The Vulnerability Assessment autoprovisioning configuration
     */
    @JvmName("jtqlkittmvlscmpg")
    public suspend
    fun vaAutoProvisioning(argument: suspend DefenderForServersGcpOfferingVaAutoProvisioningArgsBuilder.() -> Unit) {
        val toBeMapped = DefenderForServersGcpOfferingVaAutoProvisioningArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.vaAutoProvisioning = mapped
    }

    /**
     * @param value The Microsoft Defender for Server VM scanning configuration
     */
    @JvmName("qkdhjnwylnfxjndt")
    public suspend fun vmScanners(`value`: DefenderForServersGcpOfferingVmScannersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmScanners = mapped
    }

    /**
     * @param argument The Microsoft Defender for Server VM scanning configuration
     */
    @JvmName("cpoamhyspkmlmvut")
    public suspend
    fun vmScanners(argument: suspend DefenderForServersGcpOfferingVmScannersArgsBuilder.() -> Unit) {
        val toBeMapped = DefenderForServersGcpOfferingVmScannersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.vmScanners = mapped
    }

    internal fun build(): DefenderForServersGcpOfferingArgs = DefenderForServersGcpOfferingArgs(
        arcAutoProvisioning = arcAutoProvisioning,
        defenderForServers = defenderForServers,
        mdeAutoProvisioning = mdeAutoProvisioning,
        offeringType = offeringType ?: throw PulumiNullFieldException("offeringType"),
        subPlan = subPlan,
        vaAutoProvisioning = vaAutoProvisioning,
        vmScanners = vmScanners,
    )
}
