@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderForServersGcpOfferingSubPlanArgs.builder
import com.pulumi.azurenative.security.kotlin.enums.SubPlan
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * configuration for the servers offering subPlan
 * @property type The available sub plans
 */
public data class DefenderForServersGcpOfferingSubPlanArgs(
    public val type: Output<Either<String, SubPlan>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderForServersGcpOfferingSubPlanArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.DefenderForServersGcpOfferingSubPlanArgs =
        com.pulumi.azurenative.security.inputs.DefenderForServersGcpOfferingSubPlanArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DefenderForServersGcpOfferingSubPlanArgs].
 */
@PulumiTagMarker
public class DefenderForServersGcpOfferingSubPlanArgsBuilder internal constructor() {
    private var type: Output<Either<String, SubPlan>>? = null

    /**
     * @param value The available sub plans
     */
    @JvmName("mjewroomtsexwwsc")
    public suspend fun type(`value`: Output<Either<String, SubPlan>>) {
        this.type = value
    }

    /**
     * @param value The available sub plans
     */
    @JvmName("hkpfsqkjbkgwmnej")
    public suspend fun type(`value`: Either<String, SubPlan>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The available sub plans
     */
    @JvmName("iaskaqlvwivepmml")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SubPlan>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The available sub plans
     */
    @JvmName("yypssjeonlhdtawt")
    public fun type(`value`: SubPlan) {
        val toBeMapped = Either.ofRight<String, SubPlan>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DefenderForServersGcpOfferingSubPlanArgs =
        DefenderForServersGcpOfferingSubPlanArgs(
            type = type,
        )
}
