@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderForServersGcpOfferingVmScannersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The Microsoft Defender for Server VM scanning configuration
 * @property configuration configuration for Microsoft Defender for Server VM scanning
 * @property enabled Is Microsoft Defender for Server VM scanning enabled
 */
public data class DefenderForServersGcpOfferingVmScannersArgs(
    public val configuration:
    Output<DefenderForServersGcpOfferingConfigurationConfigurationConfigurationArgs>? = null,
    public val enabled: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderForServersGcpOfferingVmScannersArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.DefenderForServersGcpOfferingVmScannersArgs =
        com.pulumi.azurenative.security.inputs.DefenderForServersGcpOfferingVmScannersArgs.builder()
            .configuration(configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefenderForServersGcpOfferingVmScannersArgs].
 */
@PulumiTagMarker
public class DefenderForServersGcpOfferingVmScannersArgsBuilder internal constructor() {
    private var configuration:
        Output<DefenderForServersGcpOfferingConfigurationConfigurationConfigurationArgs>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value configuration for Microsoft Defender for Server VM scanning
     */
    @JvmName("vkhacprwhmmsexec")
    public suspend
    fun configuration(`value`: Output<DefenderForServersGcpOfferingConfigurationConfigurationConfigurationArgs>) {
        this.configuration = value
    }

    /**
     * @param value Is Microsoft Defender for Server VM scanning enabled
     */
    @JvmName("sipwxsxhjnerpuib")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value configuration for Microsoft Defender for Server VM scanning
     */
    @JvmName("imyggjrtyslwsskm")
    public suspend
    fun configuration(`value`: DefenderForServersGcpOfferingConfigurationConfigurationConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument configuration for Microsoft Defender for Server VM scanning
     */
    @JvmName("hyrlltakgrlyxwtg")
    public suspend
    fun configuration(argument: suspend DefenderForServersGcpOfferingConfigurationConfigurationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            DefenderForServersGcpOfferingConfigurationConfigurationConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value Is Microsoft Defender for Server VM scanning enabled
     */
    @JvmName("ptoivnnddvxecgif")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): DefenderForServersGcpOfferingVmScannersArgs =
        DefenderForServersGcpOfferingVmScannersArgs(
            configuration = configuration,
            enabled = enabled,
        )
}
