@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GetAdvancedThreatProtectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceId The identifier of the resource.
 * @property settingName Advanced Threat Protection setting name.
 */
public data class GetAdvancedThreatProtectionPlainArgs(
    public val resourceId: String,
    public val settingName: String,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GetAdvancedThreatProtectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GetAdvancedThreatProtectionPlainArgs =
        com.pulumi.azurenative.security.inputs.GetAdvancedThreatProtectionPlainArgs.builder()
            .resourceId(resourceId.let({ args0 -> args0 }))
            .settingName(settingName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAdvancedThreatProtectionPlainArgs].
 */
@PulumiTagMarker
public class GetAdvancedThreatProtectionPlainArgsBuilder internal constructor() {
    private var resourceId: String? = null

    private var settingName: String? = null

    /**
     * @param value The identifier of the resource.
     */
    @JvmName("xjjjamacrhsaojhw")
    public suspend fun resourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceId = mapped
    }

    /**
     * @param value Advanced Threat Protection setting name.
     */
    @JvmName("tjpxsbidinodqnxj")
    public suspend fun settingName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.settingName = mapped
    }

    internal fun build(): GetAdvancedThreatProtectionPlainArgs = GetAdvancedThreatProtectionPlainArgs(
        resourceId = resourceId ?: throw PulumiNullFieldException("resourceId"),
        settingName = settingName ?: throw PulumiNullFieldException("settingName"),
    )
}
