@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GetAlertsSuppressionRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property alertsSuppressionRuleName The unique name of the suppression alert rule
 */
public data class GetAlertsSuppressionRulePlainArgs(
    public val alertsSuppressionRuleName: String,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GetAlertsSuppressionRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GetAlertsSuppressionRulePlainArgs =
        com.pulumi.azurenative.security.inputs.GetAlertsSuppressionRulePlainArgs.builder()
            .alertsSuppressionRuleName(alertsSuppressionRuleName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAlertsSuppressionRulePlainArgs].
 */
@PulumiTagMarker
public class GetAlertsSuppressionRulePlainArgsBuilder internal constructor() {
    private var alertsSuppressionRuleName: String? = null

    /**
     * @param value The unique name of the suppression alert rule
     */
    @JvmName("oiafkwigpnqonwms")
    public suspend fun alertsSuppressionRuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.alertsSuppressionRuleName = mapped
    }

    internal fun build(): GetAlertsSuppressionRulePlainArgs = GetAlertsSuppressionRulePlainArgs(
        alertsSuppressionRuleName = alertsSuppressionRuleName ?: throw
            PulumiNullFieldException("alertsSuppressionRuleName"),
    )
}
