@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GetAssessmentMetadataInSubscriptionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property assessmentMetadataName The Assessment Key - Unique key for the assessment type
 */
public data class GetAssessmentMetadataInSubscriptionPlainArgs(
    public val assessmentMetadataName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.GetAssessmentMetadataInSubscriptionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.GetAssessmentMetadataInSubscriptionPlainArgs =
        com.pulumi.azurenative.security.inputs.GetAssessmentMetadataInSubscriptionPlainArgs.builder()
            .assessmentMetadataName(assessmentMetadataName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAssessmentMetadataInSubscriptionPlainArgs].
 */
@PulumiTagMarker
public class GetAssessmentMetadataInSubscriptionPlainArgsBuilder internal constructor() {
    private var assessmentMetadataName: String? = null

    /**
     * @param value The Assessment Key - Unique key for the assessment type
     */
    @JvmName("vxqqntckmwdvsknr")
    public suspend fun assessmentMetadataName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.assessmentMetadataName = mapped
    }

    internal fun build(): GetAssessmentMetadataInSubscriptionPlainArgs =
        GetAssessmentMetadataInSubscriptionPlainArgs(
            assessmentMetadataName = assessmentMetadataName ?: throw
                PulumiNullFieldException("assessmentMetadataName"),
        )
}
