@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GetCustomAssessmentAutomationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property customAssessmentAutomationName Name of the Custom Assessment Automation.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 */
public data class GetCustomAssessmentAutomationPlainArgs(
    public val customAssessmentAutomationName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GetCustomAssessmentAutomationPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.GetCustomAssessmentAutomationPlainArgs =
        com.pulumi.azurenative.security.inputs.GetCustomAssessmentAutomationPlainArgs.builder()
            .customAssessmentAutomationName(customAssessmentAutomationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCustomAssessmentAutomationPlainArgs].
 */
@PulumiTagMarker
public class GetCustomAssessmentAutomationPlainArgsBuilder internal constructor() {
    private var customAssessmentAutomationName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Custom Assessment Automation.
     */
    @JvmName("cngbshodtnxsecjd")
    public suspend fun customAssessmentAutomationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.customAssessmentAutomationName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("xojxotpxjkbgcvxu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCustomAssessmentAutomationPlainArgs =
        GetCustomAssessmentAutomationPlainArgs(
            customAssessmentAutomationName = customAssessmentAutomationName ?: throw
                PulumiNullFieldException("customAssessmentAutomationName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
