@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GetDevOpsConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property securityConnectorName The security connector name.
 */
public data class GetDevOpsConfigurationPlainArgs(
    public val resourceGroupName: String,
    public val securityConnectorName: String,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GetDevOpsConfigurationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GetDevOpsConfigurationPlainArgs =
        com.pulumi.azurenative.security.inputs.GetDevOpsConfigurationPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .securityConnectorName(securityConnectorName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDevOpsConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetDevOpsConfigurationPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var securityConnectorName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("oadtwxjerhtmdjvw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The security connector name.
     */
    @JvmName("fuoxsuecigrluara")
    public suspend fun securityConnectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.securityConnectorName = mapped
    }

    internal fun build(): GetDevOpsConfigurationPlainArgs = GetDevOpsConfigurationPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        securityConnectorName = securityConnectorName ?: throw
            PulumiNullFieldException("securityConnectorName"),
    )
}
