@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GetJitNetworkAccessPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ascLocation The location where ASC stores the data of the subscription. can be retrieved from Get locations
 * @property jitNetworkAccessPolicyName Name of a Just-in-Time access configuration policy.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 */
public data class GetJitNetworkAccessPolicyPlainArgs(
    public val ascLocation: String,
    public val jitNetworkAccessPolicyName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GetJitNetworkAccessPolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GetJitNetworkAccessPolicyPlainArgs =
        com.pulumi.azurenative.security.inputs.GetJitNetworkAccessPolicyPlainArgs.builder()
            .ascLocation(ascLocation.let({ args0 -> args0 }))
            .jitNetworkAccessPolicyName(jitNetworkAccessPolicyName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetJitNetworkAccessPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetJitNetworkAccessPolicyPlainArgsBuilder internal constructor() {
    private var ascLocation: String? = null

    private var jitNetworkAccessPolicyName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The location where ASC stores the data of the subscription. can be retrieved from Get locations
     */
    @JvmName("jahyyiyfsyfqspmy")
    public suspend fun ascLocation(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ascLocation = mapped
    }

    /**
     * @param value Name of a Just-in-Time access configuration policy.
     */
    @JvmName("possmemokpxkwcrg")
    public suspend fun jitNetworkAccessPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.jitNetworkAccessPolicyName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("eklvlkvrltqyvrou")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetJitNetworkAccessPolicyPlainArgs = GetJitNetworkAccessPolicyPlainArgs(
        ascLocation = ascLocation ?: throw PulumiNullFieldException("ascLocation"),
        jitNetworkAccessPolicyName = jitNetworkAccessPolicyName ?: throw
            PulumiNullFieldException("jitNetworkAccessPolicyName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
