@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GetSecurityOperatorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property pricingName name of the pricing configuration
 * @property securityOperatorName name of the securityOperator
 */
public data class GetSecurityOperatorPlainArgs(
    public val pricingName: String,
    public val securityOperatorName: String,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GetSecurityOperatorPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GetSecurityOperatorPlainArgs =
        com.pulumi.azurenative.security.inputs.GetSecurityOperatorPlainArgs.builder()
            .pricingName(pricingName.let({ args0 -> args0 }))
            .securityOperatorName(securityOperatorName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSecurityOperatorPlainArgs].
 */
@PulumiTagMarker
public class GetSecurityOperatorPlainArgsBuilder internal constructor() {
    private var pricingName: String? = null

    private var securityOperatorName: String? = null

    /**
     * @param value name of the pricing configuration
     */
    @JvmName("cfnfipgflafthnai")
    public suspend fun pricingName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.pricingName = mapped
    }

    /**
     * @param value name of the securityOperator
     */
    @JvmName("jocejoeetfrxjace")
    public suspend fun securityOperatorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.securityOperatorName = mapped
    }

    internal fun build(): GetSecurityOperatorPlainArgs = GetSecurityOperatorPlainArgs(
        pricingName = pricingName ?: throw PulumiNullFieldException("pricingName"),
        securityOperatorName = securityOperatorName ?: throw
            PulumiNullFieldException("securityOperatorName"),
    )
}
