@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GovernanceRuleEmailNotificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The governance email weekly notification configuration
 * @property disableManagerEmailNotification Defines whether manager email notifications are disabled
 * @property disableOwnerEmailNotification Defines whether owner email notifications are disabled
 */
public data class GovernanceRuleEmailNotificationArgs(
    public val disableManagerEmailNotification: Output<Boolean>? = null,
    public val disableOwnerEmailNotification: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GovernanceRuleEmailNotificationArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GovernanceRuleEmailNotificationArgs =
        com.pulumi.azurenative.security.inputs.GovernanceRuleEmailNotificationArgs.builder()
            .disableManagerEmailNotification(disableManagerEmailNotification?.applyValue({ args0 -> args0 }))
            .disableOwnerEmailNotification(
                disableOwnerEmailNotification?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [GovernanceRuleEmailNotificationArgs].
 */
@PulumiTagMarker
public class GovernanceRuleEmailNotificationArgsBuilder internal constructor() {
    private var disableManagerEmailNotification: Output<Boolean>? = null

    private var disableOwnerEmailNotification: Output<Boolean>? = null

    /**
     * @param value Defines whether manager email notifications are disabled
     */
    @JvmName("hoamyudqadkmlyjt")
    public suspend fun disableManagerEmailNotification(`value`: Output<Boolean>) {
        this.disableManagerEmailNotification = value
    }

    /**
     * @param value Defines whether owner email notifications are disabled
     */
    @JvmName("glgroaaaygeewakl")
    public suspend fun disableOwnerEmailNotification(`value`: Output<Boolean>) {
        this.disableOwnerEmailNotification = value
    }

    /**
     * @param value Defines whether manager email notifications are disabled
     */
    @JvmName("tgkpvyqpssobgeaf")
    public suspend fun disableManagerEmailNotification(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableManagerEmailNotification = mapped
    }

    /**
     * @param value Defines whether owner email notifications are disabled
     */
    @JvmName("lpvtscrbpdwkyfpu")
    public suspend fun disableOwnerEmailNotification(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableOwnerEmailNotification = mapped
    }

    internal fun build(): GovernanceRuleEmailNotificationArgs = GovernanceRuleEmailNotificationArgs(
        disableManagerEmailNotification = disableManagerEmailNotification,
        disableOwnerEmailNotification = disableOwnerEmailNotification,
    )
}
