@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.JitNetworkAccessRequestArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property justification The justification for making the initiate request
 * @property requestor The identity of the person who made the request
 * @property startTimeUtc The start time of the request in UTC
 * @property virtualMachines
 */
public data class JitNetworkAccessRequestArgs(
    public val justification: Output<String>? = null,
    public val requestor: Output<String>,
    public val startTimeUtc: Output<String>,
    public val virtualMachines: Output<List<JitNetworkAccessRequestVirtualMachineArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.JitNetworkAccessRequestArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.JitNetworkAccessRequestArgs =
        com.pulumi.azurenative.security.inputs.JitNetworkAccessRequestArgs.builder()
            .justification(justification?.applyValue({ args0 -> args0 }))
            .requestor(requestor.applyValue({ args0 -> args0 }))
            .startTimeUtc(startTimeUtc.applyValue({ args0 -> args0 }))
            .virtualMachines(
                virtualMachines.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [JitNetworkAccessRequestArgs].
 */
@PulumiTagMarker
public class JitNetworkAccessRequestArgsBuilder internal constructor() {
    private var justification: Output<String>? = null

    private var requestor: Output<String>? = null

    private var startTimeUtc: Output<String>? = null

    private var virtualMachines: Output<List<JitNetworkAccessRequestVirtualMachineArgs>>? = null

    /**
     * @param value The justification for making the initiate request
     */
    @JvmName("llguairwrbclyall")
    public suspend fun justification(`value`: Output<String>) {
        this.justification = value
    }

    /**
     * @param value The identity of the person who made the request
     */
    @JvmName("catqwgnjkkpdjkhl")
    public suspend fun requestor(`value`: Output<String>) {
        this.requestor = value
    }

    /**
     * @param value The start time of the request in UTC
     */
    @JvmName("nsxvdunbghisfpyk")
    public suspend fun startTimeUtc(`value`: Output<String>) {
        this.startTimeUtc = value
    }

    /**
     * @param value
     */
    @JvmName("ulbafspgewsquysc")
    public suspend
    fun virtualMachines(`value`: Output<List<JitNetworkAccessRequestVirtualMachineArgs>>) {
        this.virtualMachines = value
    }

    @JvmName("slpnyendrqofqypm")
    public suspend fun virtualMachines(
        vararg
        values: Output<JitNetworkAccessRequestVirtualMachineArgs>,
    ) {
        this.virtualMachines = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("wgirusyysfqqcief")
    public suspend
    fun virtualMachines(values: List<Output<JitNetworkAccessRequestVirtualMachineArgs>>) {
        this.virtualMachines = Output.all(values)
    }

    /**
     * @param value The justification for making the initiate request
     */
    @JvmName("btfakcropgqrjgnn")
    public suspend fun justification(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.justification = mapped
    }

    /**
     * @param value The identity of the person who made the request
     */
    @JvmName("ytfgiqxemqdecrxh")
    public suspend fun requestor(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requestor = mapped
    }

    /**
     * @param value The start time of the request in UTC
     */
    @JvmName("mfxpkdcotmjdbpej")
    public suspend fun startTimeUtc(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.startTimeUtc = mapped
    }

    /**
     * @param value
     */
    @JvmName("jmyvkxltxydejfva")
    public suspend fun virtualMachines(`value`: List<JitNetworkAccessRequestVirtualMachineArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualMachines = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wpyflsbiwmifgmag")
    public suspend
    fun virtualMachines(argument: List<suspend JitNetworkAccessRequestVirtualMachineArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            JitNetworkAccessRequestVirtualMachineArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualMachines = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gqrxkcfpbdhnhgiu")
    public suspend fun virtualMachines(
        vararg
        argument: suspend JitNetworkAccessRequestVirtualMachineArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            JitNetworkAccessRequestVirtualMachineArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualMachines = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wdmvywyjoscmvnev")
    public suspend
    fun virtualMachines(argument: suspend JitNetworkAccessRequestVirtualMachineArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            JitNetworkAccessRequestVirtualMachineArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.virtualMachines = mapped
    }

    /**
     * @param values
     */
    @JvmName("stsjjmommvaivynd")
    public suspend fun virtualMachines(vararg values: JitNetworkAccessRequestVirtualMachineArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualMachines = mapped
    }

    internal fun build(): JitNetworkAccessRequestArgs = JitNetworkAccessRequestArgs(
        justification = justification,
        requestor = requestor ?: throw PulumiNullFieldException("requestor"),
        startTimeUtc = startTimeUtc ?: throw PulumiNullFieldException("startTimeUtc"),
        virtualMachines = virtualMachines ?: throw PulumiNullFieldException("virtualMachines"),
    )
}
