@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.JitNetworkAccessRequestVirtualMachineArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property id Resource ID of the virtual machine that is linked to this policy
 * @property ports The ports that were opened for the virtual machine
 */
public data class JitNetworkAccessRequestVirtualMachineArgs(
    public val id: Output<String>,
    public val ports: Output<List<JitNetworkAccessRequestPortArgs>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.JitNetworkAccessRequestVirtualMachineArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.JitNetworkAccessRequestVirtualMachineArgs =
        com.pulumi.azurenative.security.inputs.JitNetworkAccessRequestVirtualMachineArgs.builder()
            .id(id.applyValue({ args0 -> args0 }))
            .ports(
                ports.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [JitNetworkAccessRequestVirtualMachineArgs].
 */
@PulumiTagMarker
public class JitNetworkAccessRequestVirtualMachineArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var ports: Output<List<JitNetworkAccessRequestPortArgs>>? = null

    /**
     * @param value Resource ID of the virtual machine that is linked to this policy
     */
    @JvmName("ilexlglrtlbixjal")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The ports that were opened for the virtual machine
     */
    @JvmName("nelbnjxqhsmtqjgp")
    public suspend fun ports(`value`: Output<List<JitNetworkAccessRequestPortArgs>>) {
        this.ports = value
    }

    @JvmName("rpodxhsejauyqnqh")
    public suspend fun ports(vararg values: Output<JitNetworkAccessRequestPortArgs>) {
        this.ports = Output.all(values.asList())
    }

    /**
     * @param values The ports that were opened for the virtual machine
     */
    @JvmName("jixkampkujgeytpr")
    public suspend fun ports(values: List<Output<JitNetworkAccessRequestPortArgs>>) {
        this.ports = Output.all(values)
    }

    /**
     * @param value Resource ID of the virtual machine that is linked to this policy
     */
    @JvmName("ctcuhgujwxhiakmk")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The ports that were opened for the virtual machine
     */
    @JvmName("cejjwpoegkfycaqi")
    public suspend fun ports(`value`: List<JitNetworkAccessRequestPortArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ports = mapped
    }

    /**
     * @param argument The ports that were opened for the virtual machine
     */
    @JvmName("jtocovuxummgrftc")
    public suspend
    fun ports(argument: List<suspend JitNetworkAccessRequestPortArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            JitNetworkAccessRequestPortArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ports = mapped
    }

    /**
     * @param argument The ports that were opened for the virtual machine
     */
    @JvmName("smgyyahtooqkehmw")
    public suspend fun ports(
        vararg
        argument: suspend JitNetworkAccessRequestPortArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            JitNetworkAccessRequestPortArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ports = mapped
    }

    /**
     * @param argument The ports that were opened for the virtual machine
     */
    @JvmName("gyjkxqqfwpwrqmcj")
    public suspend fun ports(argument: suspend JitNetworkAccessRequestPortArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            JitNetworkAccessRequestPortArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ports = mapped
    }

    /**
     * @param values The ports that were opened for the virtual machine
     */
    @JvmName("hjcdnpwswtvsnxea")
    public suspend fun ports(vararg values: JitNetworkAccessRequestPortArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ports = mapped
    }

    internal fun build(): JitNetworkAccessRequestVirtualMachineArgs =
        JitNetworkAccessRequestVirtualMachineArgs(
            id = id ?: throw PulumiNullFieldException("id"),
            ports = ports ?: throw PulumiNullFieldException("ports"),
        )
}
