@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.MalwareScanningPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of Malware Scanning.
 * @property capGBPerMonth Defines the max GB to be scanned per Month. Set to -1 if no capping is needed.
 * @property isEnabled Indicates whether On Upload malware scanning should be enabled.
 * @property scanResultsEventGridTopicResourceId Optional. Resource id of an Event Grid Topic to send scan results to.
 */
public data class MalwareScanningPropertiesArgs(
    public val capGBPerMonth: Output<Int>? = null,
    public val isEnabled: Output<Boolean>? = null,
    public val scanResultsEventGridTopicResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.MalwareScanningPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.MalwareScanningPropertiesArgs =
        com.pulumi.azurenative.security.inputs.MalwareScanningPropertiesArgs.builder()
            .capGBPerMonth(capGBPerMonth?.applyValue({ args0 -> args0 }))
            .isEnabled(isEnabled?.applyValue({ args0 -> args0 }))
            .scanResultsEventGridTopicResourceId(
                scanResultsEventGridTopicResourceId?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [MalwareScanningPropertiesArgs].
 */
@PulumiTagMarker
public class MalwareScanningPropertiesArgsBuilder internal constructor() {
    private var capGBPerMonth: Output<Int>? = null

    private var isEnabled: Output<Boolean>? = null

    private var scanResultsEventGridTopicResourceId: Output<String>? = null

    /**
     * @param value Defines the max GB to be scanned per Month. Set to -1 if no capping is needed.
     */
    @JvmName("iybarxhveomwvryv")
    public suspend fun capGBPerMonth(`value`: Output<Int>) {
        this.capGBPerMonth = value
    }

    /**
     * @param value Indicates whether On Upload malware scanning should be enabled.
     */
    @JvmName("cpqqmewvnsxckabt")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value Optional. Resource id of an Event Grid Topic to send scan results to.
     */
    @JvmName("qyjesqcfyirtkbtv")
    public suspend fun scanResultsEventGridTopicResourceId(`value`: Output<String>) {
        this.scanResultsEventGridTopicResourceId = value
    }

    /**
     * @param value Defines the max GB to be scanned per Month. Set to -1 if no capping is needed.
     */
    @JvmName("bpwrhksplvmjxupm")
    public suspend fun capGBPerMonth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capGBPerMonth = mapped
    }

    /**
     * @param value Indicates whether On Upload malware scanning should be enabled.
     */
    @JvmName("uelcfpunmwkyyoeg")
    public suspend fun isEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value Optional. Resource id of an Event Grid Topic to send scan results to.
     */
    @JvmName("jxlhnrjsaempqlgv")
    public suspend fun scanResultsEventGridTopicResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scanResultsEventGridTopicResourceId = mapped
    }

    internal fun build(): MalwareScanningPropertiesArgs = MalwareScanningPropertiesArgs(
        capGBPerMonth = capGBPerMonth,
        isEnabled = isEnabled,
        scanResultsEventGridTopicResourceId = scanResultsEventGridTopicResourceId,
    )
}
