@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.ProtectionModeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The protection mode of the collection/file types. Exe/Msi/Script are used for Windows, Executable is used for Linux.
 * @property exe The application control policy enforcement/protection mode of the machine group
 * @property executable The application control policy enforcement/protection mode of the machine group
 * @property msi The application control policy enforcement/protection mode of the machine group
 * @property script The application control policy enforcement/protection mode of the machine group
 */
public data class ProtectionModeArgs(
    public val exe: Output<String>? = null,
    public val executable: Output<String>? = null,
    public val msi: Output<String>? = null,
    public val script: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.ProtectionModeArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.ProtectionModeArgs =
        com.pulumi.azurenative.security.inputs.ProtectionModeArgs.builder()
            .exe(exe?.applyValue({ args0 -> args0 }))
            .executable(executable?.applyValue({ args0 -> args0 }))
            .msi(msi?.applyValue({ args0 -> args0 }))
            .script(script?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProtectionModeArgs].
 */
@PulumiTagMarker
public class ProtectionModeArgsBuilder internal constructor() {
    private var exe: Output<String>? = null

    private var executable: Output<String>? = null

    private var msi: Output<String>? = null

    private var script: Output<String>? = null

    /**
     * @param value The application control policy enforcement/protection mode of the machine group
     */
    @JvmName("vqkyhgwculkvttvy")
    public suspend fun exe(`value`: Output<String>) {
        this.exe = value
    }

    /**
     * @param value The application control policy enforcement/protection mode of the machine group
     */
    @JvmName("lyrqvoveuxeeclck")
    public suspend fun executable(`value`: Output<String>) {
        this.executable = value
    }

    /**
     * @param value The application control policy enforcement/protection mode of the machine group
     */
    @JvmName("hinjoxchdoinxegj")
    public suspend fun msi(`value`: Output<String>) {
        this.msi = value
    }

    /**
     * @param value The application control policy enforcement/protection mode of the machine group
     */
    @JvmName("jbyotubslibwfpue")
    public suspend fun script(`value`: Output<String>) {
        this.script = value
    }

    /**
     * @param value The application control policy enforcement/protection mode of the machine group
     */
    @JvmName("tyqcnnrjfhgbaevn")
    public suspend fun exe(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exe = mapped
    }

    /**
     * @param value The application control policy enforcement/protection mode of the machine group
     */
    @JvmName("iswnrulqcxbjwdqb")
    public suspend fun executable(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executable = mapped
    }

    /**
     * @param value The application control policy enforcement/protection mode of the machine group
     */
    @JvmName("tlxsoiacqbdwerym")
    public suspend fun msi(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.msi = mapped
    }

    /**
     * @param value The application control policy enforcement/protection mode of the machine group
     */
    @JvmName("vlcuqgfefegwvtdv")
    public suspend fun script(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.script = mapped
    }

    internal fun build(): ProtectionModeArgs = ProtectionModeArgs(
        exe = exe,
        executable = executable,
        msi = msi,
        script = script,
    )
}
