@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.RecommendationConfigurationPropertiesArgs.builder
import com.pulumi.azurenative.security.kotlin.enums.RecommendationConfigStatus
import com.pulumi.azurenative.security.kotlin.enums.RecommendationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The type of IoT Security recommendation.
 * @property recommendationType The type of IoT Security recommendation.
 * @property status Recommendation status. When the recommendation status is disabled recommendations are not generated.
 */
public data class RecommendationConfigurationPropertiesArgs(
    public val recommendationType: Output<Either<String, RecommendationType>>,
    public val status: Output<Either<String, RecommendationConfigStatus>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.RecommendationConfigurationPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.RecommendationConfigurationPropertiesArgs =
        com.pulumi.azurenative.security.inputs.RecommendationConfigurationPropertiesArgs.builder()
            .recommendationType(
                recommendationType.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .status(
                status.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [RecommendationConfigurationPropertiesArgs].
 */
@PulumiTagMarker
public class RecommendationConfigurationPropertiesArgsBuilder internal constructor() {
    private var recommendationType: Output<Either<String, RecommendationType>>? = null

    private var status: Output<Either<String, RecommendationConfigStatus>>? = null

    /**
     * @param value The type of IoT Security recommendation.
     */
    @JvmName("vwvpobobrlgfwhhs")
    public suspend fun recommendationType(`value`: Output<Either<String, RecommendationType>>) {
        this.recommendationType = value
    }

    /**
     * @param value Recommendation status. When the recommendation status is disabled recommendations are not generated.
     */
    @JvmName("qrjuufcjecjesnfg")
    public suspend fun status(`value`: Output<Either<String, RecommendationConfigStatus>>) {
        this.status = value
    }

    /**
     * @param value The type of IoT Security recommendation.
     */
    @JvmName("evmirwtbldusuyjc")
    public suspend fun recommendationType(`value`: Either<String, RecommendationType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recommendationType = mapped
    }

    /**
     * @param value The type of IoT Security recommendation.
     */
    @JvmName("igkeakmfmshbcmfw")
    public fun recommendationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RecommendationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recommendationType = mapped
    }

    /**
     * @param value The type of IoT Security recommendation.
     */
    @JvmName("lvsbaqavklqsbbdw")
    public fun recommendationType(`value`: RecommendationType) {
        val toBeMapped = Either.ofRight<String, RecommendationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recommendationType = mapped
    }

    /**
     * @param value Recommendation status. When the recommendation status is disabled recommendations are not generated.
     */
    @JvmName("tibefroqmfjwbrff")
    public suspend fun status(`value`: Either<String, RecommendationConfigStatus>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Recommendation status. When the recommendation status is disabled recommendations are not generated.
     */
    @JvmName("eswrqtnflumrbxap")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RecommendationConfigStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Recommendation status. When the recommendation status is disabled recommendations are not generated.
     */
    @JvmName("tkwibrrhlvtekibb")
    public fun status(`value`: RecommendationConfigStatus) {
        val toBeMapped = Either.ofRight<String, RecommendationConfigStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): RecommendationConfigurationPropertiesArgs =
        RecommendationConfigurationPropertiesArgs(
            recommendationType = recommendationType ?: throw PulumiNullFieldException("recommendationType"),
            status = status ?: throw PulumiNullFieldException("status"),
        )
}
