@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.ScopeElementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A more specific scope used to identify the alerts to suppress.
 * @property field The alert entity type to suppress by.
 */
public data class ScopeElementArgs(
    public val `field`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.ScopeElementArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.ScopeElementArgs =
        com.pulumi.azurenative.security.inputs.ScopeElementArgs.builder()
            .`field`(`field`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScopeElementArgs].
 */
@PulumiTagMarker
public class ScopeElementArgsBuilder internal constructor() {
    private var `field`: Output<String>? = null

    /**
     * @param value The alert entity type to suppress by.
     */
    @JvmName("gmsglcbwmlyxnsue")
    public suspend fun `field`(`value`: Output<String>) {
        this.`field` = value
    }

    /**
     * @param value The alert entity type to suppress by.
     */
    @JvmName("muumsyiaigdepjkl")
    public suspend fun `field`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`field` = mapped
    }

    internal fun build(): ScopeElementArgs = ScopeElementArgs(
        `field` = `field`,
    )
}
