@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.SecurityContactPropertiesNotificationsByRoleArgs.builder
import com.pulumi.azurenative.security.kotlin.enums.Roles
import com.pulumi.azurenative.security.kotlin.enums.State
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines whether to send email notifications from Microsoft Defender for Cloud to persons with specific RBAC roles on the subscription.
 * @property roles Defines which RBAC roles will get email notifications from Microsoft Defender for Cloud. List of allowed RBAC roles:
 * @property state Defines whether to send email notifications from AMicrosoft Defender for Cloud to persons with specific RBAC roles on the subscription.
 */
public data class SecurityContactPropertiesNotificationsByRoleArgs(
    public val roles: Output<List<Either<String, Roles>>>? = null,
    public val state: Output<Either<String, State>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.SecurityContactPropertiesNotificationsByRoleArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.SecurityContactPropertiesNotificationsByRoleArgs =
        com.pulumi.azurenative.security.inputs.SecurityContactPropertiesNotificationsByRoleArgs.builder()
            .roles(
                roles?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 ->
                            args0.let({ args0 -> args0.toJava() })
                        })
                    })
                }),
            )
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SecurityContactPropertiesNotificationsByRoleArgs].
 */
@PulumiTagMarker
public class SecurityContactPropertiesNotificationsByRoleArgsBuilder internal constructor() {
    private var roles: Output<List<Either<String, Roles>>>? = null

    private var state: Output<Either<String, State>>? = null

    /**
     * @param value Defines which RBAC roles will get email notifications from Microsoft Defender for Cloud. List of allowed RBAC roles:
     */
    @JvmName("ceskwboxslffplvv")
    public suspend fun roles(`value`: Output<List<Either<String, Roles>>>) {
        this.roles = value
    }

    @JvmName("nhctelfrjeufwmjc")
    public suspend fun roles(vararg values: Output<Either<String, Roles>>) {
        this.roles = Output.all(values.asList())
    }

    /**
     * @param values Defines which RBAC roles will get email notifications from Microsoft Defender for Cloud. List of allowed RBAC roles:
     */
    @JvmName("qvjinvxdsyikfajr")
    public suspend fun roles(values: List<Output<Either<String, Roles>>>) {
        this.roles = Output.all(values)
    }

    /**
     * @param value Defines whether to send email notifications from AMicrosoft Defender for Cloud to persons with specific RBAC roles on the subscription.
     */
    @JvmName("tkonrejufrhjrieg")
    public suspend fun state(`value`: Output<Either<String, State>>) {
        this.state = value
    }

    /**
     * @param value Defines which RBAC roles will get email notifications from Microsoft Defender for Cloud. List of allowed RBAC roles:
     */
    @JvmName("sbtrenamlbdrchio")
    public suspend fun roles(`value`: List<Either<String, Roles>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param values Defines which RBAC roles will get email notifications from Microsoft Defender for Cloud. List of allowed RBAC roles:
     */
    @JvmName("gpkkrvajrpfaftex")
    public suspend fun roles(vararg values: Either<String, Roles>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param value Defines whether to send email notifications from AMicrosoft Defender for Cloud to persons with specific RBAC roles on the subscription.
     */
    @JvmName("nbslcqkahaakmcyc")
    public suspend fun state(`value`: Either<String, State>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Defines whether to send email notifications from AMicrosoft Defender for Cloud to persons with specific RBAC roles on the subscription.
     */
    @JvmName("lwaygujedwhulbva")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, State>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Defines whether to send email notifications from AMicrosoft Defender for Cloud to persons with specific RBAC roles on the subscription.
     */
    @JvmName("qbjsgydjtqhkjrpt")
    public fun state(`value`: State) {
        val toBeMapped = Either.ofRight<String, State>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): SecurityContactPropertiesNotificationsByRoleArgs =
        SecurityContactPropertiesNotificationsByRoleArgs(
            roles = roles,
            state = state,
        )
}
