@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Represents a summary of the alerts of the machine group
 * @property issue An alert that machines within a group can have
 * @property numberOfVms The number of machines in the group that have this alert
 */
public data class AdaptiveApplicationControlIssueSummaryResponse(
    public val issue: String? = null,
    public val numberOfVms: Double? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.AdaptiveApplicationControlIssueSummaryResponse):
            AdaptiveApplicationControlIssueSummaryResponse =
            AdaptiveApplicationControlIssueSummaryResponse(
                issue = javaType.issue().map({ args0 -> args0 }).orElse(null),
                numberOfVms = javaType.numberOfVms().map({ args0 -> args0 }).orElse(null),
            )
    }
}
