@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The result of the assessment
 * @property cause Programmatic code for the cause of the assessment status
 * @property code Programmatic code for the status of the assessment
 * @property description Human readable description of the assessment status
 * @property firstEvaluationDate The time that the assessment was created and first evaluated. Returned as UTC time in ISO 8601 format
 * @property statusChangeDate The time that the status of the assessment last changed. Returned as UTC time in ISO 8601 format
 */
public data class AssessmentStatusResponseResponse(
    public val cause: String? = null,
    public val code: String,
    public val description: String? = null,
    public val firstEvaluationDate: String,
    public val statusChangeDate: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.AssessmentStatusResponseResponse):
            AssessmentStatusResponseResponse = AssessmentStatusResponseResponse(
            cause = javaType.cause().map({ args0 -> args0 }).orElse(null),
            code = javaType.code(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            firstEvaluationDate = javaType.firstEvaluationDate(),
            statusChangeDate = javaType.statusChangeDate(),
        )
    }
}
