@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Authorization payload.
 * @property code Gets or sets one-time OAuth code to exchange for refresh and access tokens.
 * Only used during PUT/PATCH operations. The secret is cleared during GET.
 */
public data class AuthorizationResponse(
    public val code: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.AuthorizationResponse):
            AuthorizationResponse = AuthorizationResponse(
            code = javaType.code().map({ args0 -> args0 }).orElse(null),
        )
    }
}
