@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The kinesis to s3 connection configuration
 * @property cloudRoleArn The cloud role ARN in AWS used by Kinesis to transfer data into S3
 */
public data class DefenderForContainersAwsOfferingResponseKinesisToS3(
    public val cloudRoleArn: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.DefenderForContainersAwsOfferingResponseKinesisToS3):
            DefenderForContainersAwsOfferingResponseKinesisToS3 =
            DefenderForContainersAwsOfferingResponseKinesisToS3(
                cloudRoleArn = javaType.cloudRoleArn().map({ args0 -> args0 }).orElse(null),
            )
    }
}
