@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The Defender for Storage resource.
 * @property id Resource Id
 * @property isEnabled Indicates whether Defender for Storage is enabled on this storage account.
 * @property malwareScanning Properties of Malware Scanning.
 * @property name Resource name
 * @property overrideSubscriptionLevelSettings Indicates whether the settings defined for this storage account should override the settings defined for the subscription.
 * @property sensitiveDataDiscovery Properties of Sensitive Data Discovery.
 * @property type Resource type
 */
public data class GetDefenderForStorageResult(
    public val id: String,
    public val isEnabled: Boolean? = null,
    public val malwareScanning: MalwareScanningPropertiesResponse? = null,
    public val name: String,
    public val overrideSubscriptionLevelSettings: Boolean? = null,
    public val sensitiveDataDiscovery: SensitiveDataDiscoveryPropertiesResponse? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GetDefenderForStorageResult):
            GetDefenderForStorageResult = GetDefenderForStorageResult(
            id = javaType.id(),
            isEnabled = javaType.isEnabled().map({ args0 -> args0 }).orElse(null),
            malwareScanning = javaType.malwareScanning().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.MalwareScanningPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            overrideSubscriptionLevelSettings = javaType.overrideSubscriptionLevelSettings().map({ args0 ->
                args0
            }).orElse(null),
            sensitiveDataDiscovery = javaType.sensitiveDataDiscovery().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.SensitiveDataDiscoveryPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
