@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Contact details and configurations for notifications coming from Microsoft Defender for Cloud.
 * @property alertNotifications Defines whether to send email notifications about new security alerts
 * @property emails List of email addresses which will get notifications from Microsoft Defender for Cloud by the configurations defined in this security contact.
 * @property id Resource Id
 * @property name Resource name
 * @property notificationsByRole Defines whether to send email notifications from Microsoft Defender for Cloud to persons with specific RBAC roles on the subscription.
 * @property phone The security contact's phone number
 * @property type Resource type
 */
public data class GetSecurityContactResult(
    public val alertNotifications: SecurityContactPropertiesResponseAlertNotifications? = null,
    public val emails: String? = null,
    public val id: String,
    public val name: String,
    public val notificationsByRole: SecurityContactPropertiesResponseNotificationsByRole? = null,
    public val phone: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GetSecurityContactResult):
            GetSecurityContactResult = GetSecurityContactResult(
            alertNotifications = javaType.alertNotifications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.SecurityContactPropertiesResponseAlertNotifications.Companion.toKotlin(args0)
                })
            }).orElse(null),
            emails = javaType.emails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            notificationsByRole = javaType.notificationsByRole().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.SecurityContactPropertiesResponseNotificationsByRole.Companion.toKotlin(args0)
                })
            }).orElse(null),
            phone = javaType.phone().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
