@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * GitHub Owner properties.
 * @property gitHubInternalId Gets or sets internal GitHub id.
 * @property onboardingState Details about resource onboarding status across all connectors.
 * OnboardedByOtherConnector - this resource has already been onboarded to another connector. This is only applicable to top-level resources.
 * Onboarded - this resource has already been onboarded by the specified connector.
 * NotOnboarded - this resource has not been onboarded to any connector.
 * NotApplicable - the onboarding state is not applicable to the current endpoint.
 * @property ownerUrl Gets or sets GitHub Owner url.
 * @property provisioningState The provisioning state of the resource.
 * Pending - Provisioning pending.
 * Failed - Provisioning failed.
 * Succeeded - Successful provisioning.
 * Canceled - Provisioning canceled.
 * PendingDeletion - Deletion pending.
 * DeletionSuccess - Deletion successful.
 * DeletionFailure - Deletion failure.
 * @property provisioningStatusMessage Gets or sets resource status message.
 * @property provisioningStatusUpdateTimeUtc Gets or sets time when resource was last checked.
 */
public data class GitHubOwnerPropertiesResponse(
    public val gitHubInternalId: String,
    public val onboardingState: String? = null,
    public val ownerUrl: String,
    public val provisioningState: String? = null,
    public val provisioningStatusMessage: String,
    public val provisioningStatusUpdateTimeUtc: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GitHubOwnerPropertiesResponse):
            GitHubOwnerPropertiesResponse = GitHubOwnerPropertiesResponse(
            gitHubInternalId = javaType.gitHubInternalId(),
            onboardingState = javaType.onboardingState().map({ args0 -> args0 }).orElse(null),
            ownerUrl = javaType.ownerUrl(),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            provisioningStatusMessage = javaType.provisioningStatusMessage(),
            provisioningStatusUpdateTimeUtc = javaType.provisioningStatusUpdateTimeUtc(),
        )
    }
}
