@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The github scope connector's environment data
 * @property environmentType The type of the environment data.
 * Expected value is 'GithubScope'.
 */
public data class GithubScopeEnvironmentDataResponse(
    public val environmentType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GithubScopeEnvironmentDataResponse):
            GithubScopeEnvironmentDataResponse = GithubScopeEnvironmentDataResponse(
            environmentType = javaType.environmentType(),
        )
    }
}
