@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * The governance email weekly notification configuration
 * @property disableManagerEmailNotification Defines whether manager email notifications are disabled
 * @property disableOwnerEmailNotification Defines whether owner email notifications are disabled
 */
public data class GovernanceRuleEmailNotificationResponse(
    public val disableManagerEmailNotification: Boolean? = null,
    public val disableOwnerEmailNotification: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GovernanceRuleEmailNotificationResponse):
            GovernanceRuleEmailNotificationResponse = GovernanceRuleEmailNotificationResponse(
            disableManagerEmailNotification = javaType.disableManagerEmailNotification().map({ args0 ->
                args0
            }).orElse(null),
            disableOwnerEmailNotification = javaType.disableOwnerEmailNotification().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
