@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Details of the On Premise resource that was assessed
 * @property machineName The name of the machine
 * @property source The platform where the assessed resource resides
 * Expected value is 'OnPremise'.
 * @property sourceComputerId The oms agent Id installed on the machine
 * @property vmuuid The unique Id of the machine
 * @property workspaceId Azure resource Id of the workspace the machine is attached to
 */
public data class OnPremiseResourceDetailsResponse(
    public val machineName: String,
    public val source: String,
    public val sourceComputerId: String,
    public val vmuuid: String,
    public val workspaceId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.OnPremiseResourceDetailsResponse):
            OnPremiseResourceDetailsResponse = OnPremiseResourceDetailsResponse(
            machineName = javaType.machineName(),
            source = javaType.source(),
            sourceComputerId = javaType.sourceComputerId(),
            vmuuid = javaType.vmuuid(),
            workspaceId = javaType.workspaceId(),
        )
    }
}
