@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityandcompliance.kotlin.inputs

import com.pulumi.azurenative.securityandcompliance.inputs.GetPrivateEndpointConnectionsAdtAPIPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property privateEndpointConnectionName The name of the private endpoint connection associated with the Azure resource
 * @property resourceGroupName The name of the resource group that contains the service instance.
 * @property resourceName The name of the service instance.
 */
public data class GetPrivateEndpointConnectionsAdtAPIPlainArgs(
    public val privateEndpointConnectionName: String,
    public val resourceGroupName: String,
    public val resourceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityandcompliance.inputs.GetPrivateEndpointConnectionsAdtAPIPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityandcompliance.inputs.GetPrivateEndpointConnectionsAdtAPIPlainArgs =
        com.pulumi.azurenative.securityandcompliance.inputs.GetPrivateEndpointConnectionsAdtAPIPlainArgs.builder()
            .privateEndpointConnectionName(privateEndpointConnectionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateEndpointConnectionsAdtAPIPlainArgs].
 */
@PulumiTagMarker
public class GetPrivateEndpointConnectionsAdtAPIPlainArgsBuilder internal constructor() {
    private var privateEndpointConnectionName: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The name of the private endpoint connection associated with the Azure resource
     */
    @JvmName("wvuxqeyjdjcceoky")
    public suspend fun privateEndpointConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value The name of the resource group that contains the service instance.
     */
    @JvmName("lhmjkjjtaibdticp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the service instance.
     */
    @JvmName("qwmiuikqmwioqfsg")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetPrivateEndpointConnectionsAdtAPIPlainArgs =
        GetPrivateEndpointConnectionsAdtAPIPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName ?: throw
                PulumiNullFieldException("privateEndpointConnectionName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
        )
}
