@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityandcompliance.kotlin.inputs

import com.pulumi.azurenative.securityandcompliance.inputs.PrivateEndpointConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The Private Endpoint Connection resource.
 * @property privateLinkServiceConnectionState A collection of information about the state of the connection between service consumer and provider.
 */
public data class PrivateEndpointConnectionArgs(
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityandcompliance.inputs.PrivateEndpointConnectionArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityandcompliance.inputs.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.securityandcompliance.inputs.PrivateEndpointConnectionArgs.builder()
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("uxsinwovenwyyrcm")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkServiceConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("bcknjmlpxrlsxnav")
    public suspend
    fun privateLinkServiceConnectionState(`value`: PrivateLinkServiceConnectionStateArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("lvchlapjhwsiriit")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend PrivateLinkServiceConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceConnectionStateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        privateLinkServiceConnectionState = privateLinkServiceConnectionState ?: throw
            PulumiNullFieldException("privateLinkServiceConnectionState"),
    )
}
