@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securitydevops.kotlin

import com.pulumi.azurenative.securitydevops.kotlin.outputs.GitHubConnectorPropertiesResponse
import com.pulumi.azurenative.securitydevops.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.securitydevops.kotlin.outputs.GitHubConnectorPropertiesResponse.Companion.toKotlin as gitHubConnectorPropertiesResponseToKotlin
import com.pulumi.azurenative.securitydevops.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [GitHubConnector].
 */
@PulumiTagMarker
public class GitHubConnectorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GitHubConnectorArgs = GitHubConnectorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GitHubConnectorArgsBuilder.() -> Unit) {
        val builder = GitHubConnectorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): GitHubConnector {
        val builtJavaResource =
            com.pulumi.azurenative.securitydevops.GitHubConnector(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return GitHubConnector(builtJavaResource)
    }
}

/**
 * Represents an ARM resource for /subscriptions/xxx/resourceGroups/xxx/providers/Microsoft.SecurityDevOps/gitHubConnectors.
 * Azure REST API version: 2022-09-01-preview. Prior API version in Azure Native 1.x: 2022-09-01-preview.
 * ## Example Usage
 * ### GitHubConnector_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gitHubConnector = new AzureNative.SecurityDevOps.GitHubConnector("gitHubConnector", new()
 *     {
 *         GitHubConnectorName = "testconnector",
 *         Location = "West US",
 *         Properties = new AzureNative.SecurityDevOps.Inputs.GitHubConnectorPropertiesArgs
 *         {
 *             Code = "00000000000000000000",
 *         },
 *         ResourceGroupName = "westusrg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securitydevops/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securitydevops.NewGitHubConnector(ctx, "gitHubConnector", &securitydevops.GitHubConnectorArgs{
 * 			GitHubConnectorName: pulumi.String("testconnector"),
 * 			Location:            pulumi.String("West US"),
 * 			Properties: &securitydevops.GitHubConnectorPropertiesArgs{
 * 				Code: pulumi.String("00000000000000000000"),
 * 			},
 * 			ResourceGroupName: pulumi.String("westusrg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securitydevops.GitHubConnector;
 * import com.pulumi.azurenative.securitydevops.GitHubConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gitHubConnector = new GitHubConnector("gitHubConnector", GitHubConnectorArgs.builder()
 *             .gitHubConnectorName("testconnector")
 *             .location("West US")
 *             .properties(Map.of("code", "00000000000000000000"))
 *             .resourceGroupName("westusrg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securitydevops:GitHubConnector testconnector /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SecurityDevOps/gitHubConnectors/{gitHubConnectorName}
 * ```
 */
public class GitHubConnector internal constructor(
    override val javaResource: com.pulumi.azurenative.securitydevops.GitHubConnector,
) : KotlinCustomResource(javaResource, GitHubConnectorMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the ARM resource for /subscriptions/xxx/resourceGroups/xxx/providers/Microsoft.SecurityDevOps/gitHubConnectors.
     */
    public val properties: Output<GitHubConnectorPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                gitHubConnectorPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object GitHubConnectorMapper : ResourceMapper<GitHubConnector> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securitydevops.GitHubConnector::class == javaResource::class

    override fun map(javaResource: Resource): GitHubConnector = GitHubConnector(
        javaResource as
            com.pulumi.azurenative.securitydevops.GitHubConnector,
    )
}

/**
 * @see [GitHubConnector].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GitHubConnector].
 */
public suspend fun gitHubConnector(
    name: String,
    block: suspend GitHubConnectorResourceBuilder.() -> Unit,
): GitHubConnector {
    val builder = GitHubConnectorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GitHubConnector].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gitHubConnector(name: String): GitHubConnector {
    val builder = GitHubConnectorResourceBuilder()
    builder.name(name)
    return builder.build()
}
