@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securitydevops.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Project onboarding info.
 * @property autoDiscovery
 * @property name Gets or sets name of the AzureDevOps Project.
 * @property repos Gets or sets repositories.
 */
public data class AzureDevOpsProjectMetadataResponse(
    public val autoDiscovery: String? = null,
    public val name: String? = null,
    public val repos: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securitydevops.outputs.AzureDevOpsProjectMetadataResponse):
            AzureDevOpsProjectMetadataResponse = AzureDevOpsProjectMetadataResponse(
            autoDiscovery = javaType.autoDiscovery().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            repos = javaType.repos().map({ args0 -> args0 }),
        )
    }
}
