@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.kotlin.outputs.SecurityMLAnalyticsSettingsDataSourceResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SecurityMLAnalyticsSettingsDataSourceResponse.Companion.toKotlin as securityMLAnalyticsSettingsDataSourceResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [AnomalySecurityMLAnalyticsSettings].
 */
@PulumiTagMarker
public class AnomalySecurityMLAnalyticsSettingsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AnomalySecurityMLAnalyticsSettingsArgs = AnomalySecurityMLAnalyticsSettingsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AnomalySecurityMLAnalyticsSettingsArgsBuilder.() -> Unit) {
        val builder = AnomalySecurityMLAnalyticsSettingsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AnomalySecurityMLAnalyticsSettings {
        val builtJavaResource =
            com.pulumi.azurenative.securityinsights.AnomalySecurityMLAnalyticsSettings(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AnomalySecurityMLAnalyticsSettings(builtJavaResource)
    }
}

/**
 * Represents Anomaly Security ML Analytics Settings
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2022-05-01-preview.
 * ## Example Usage
 * ### Creates or updates a Anomaly Security ML Analytics Settings.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var anomalySecurityMLAnalyticsSettings = new AzureNative.SecurityInsights.AnomalySecurityMLAnalyticsSettings("anomalySecurityMLAnalyticsSettings", new()
 *     {
 *         AnomalySettingsVersion = 0,
 *         AnomalyVersion = "1.0.5",
 *         CustomizableObservations =
 *         {
 *             { "multiSelectObservations", null },
 *             { "prioritizeExcludeObservations", null },
 *             { "singleSelectObservations", new[]
 *             {
 *                 {
 *                     { "description", "Select device vendor of network connection logs from CommonSecurityLog" },
 *                     { "name", "Device vendor" },
 *                     { "rerun", "RerunAlways" },
 *                     { "sequenceNumber", 1 },
 *                     { "supportedValues", new[]
 *                     {
 *                         "Palo Alto Networks",
 *                         "Fortinet",
 *                         "Check Point",
 *                     } },
 *                     { "supportedValuesKql", null },
 *                     { "value", new[]
 *                     {
 *                         "Palo Alto Networks",
 *                     } },
 *                     { "valuesKql", null },
 *                 },
 *             } },
 *             { "singleValueObservations", null },
 *             { "thresholdObservations", new[]
 *             {
 *                 {
 *                     { "description", "Suppress anomalies when daily data transfered (in MB) per hour is less than the chosen value" },
 *                     { "maximum", "100" },
 *                     { "minimum", "1" },
 *                     { "name", "Daily data transfer threshold in MB" },
 *                     { "rerun", "RerunAlways" },
 *                     { "sequenceNumber", 1 },
 *                     { "value", "25" },
 *                 },
 *                 {
 *                     { "description", "Triggers anomalies when number of standard deviations is greater than the chosen value" },
 *                     { "maximum", "10" },
 *                     { "minimum", "2" },
 *                     { "name", "Number of standard deviations" },
 *                     { "rerun", "RerunAlways" },
 *                     { "sequenceNumber", 2 },
 *                     { "value", "3" },
 *                 },
 *             } },
 *         },
 *         Description = "When account logs from a source region that has rarely been logged in from during the last 14 days, an anomaly is triggered.",
 *         DisplayName = "Login from unusual region",
 *         Enabled = true,
 *         Frequency = "PT1H",
 *         IsDefaultSettings = true,
 *         Kind = "Anomaly",
 *         RequiredDataConnectors = new[]
 *         {
 *             new AzureNative.SecurityInsights.Inputs.SecurityMLAnalyticsSettingsDataSourceArgs
 *             {
 *                 ConnectorId = "AWS",
 *                 DataTypes = new[]
 *                 {
 *                     "AWSCloudTrail",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myRg",
 *         SettingsDefinitionId = "f209187f-1d17-4431-94af-c141bf5f23db",
 *         SettingsResourceName = "f209187f-1d17-4431-94af-c141bf5f23db",
 *         SettingsStatus = "Production",
 *         Tactics = new[]
 *         {
 *             "Exfiltration",
 *             "CommandAndControl",
 *         },
 *         Techniques = new[]
 *         {
 *             "T1037",
 *             "T1021",
 *         },
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewAnomalySecurityMLAnalyticsSettings(ctx, "anomalySecurityMLAnalyticsSettings", &securityinsights.AnomalySecurityMLAnalyticsSettingsArgs{
 * 			AnomalySettingsVersion: pulumi.Int(0),
 * 			AnomalyVersion:         pulumi.String("1.0.5"),
 * 			CustomizableObservations: pulumi.Any{
 * 				MultiSelectObservations:       nil,
 * 				PrioritizeExcludeObservations: nil,
 * 				SingleSelectObservations: []map[string]interface{}{
 * 					map[string]interface{}{
 * 						"description":    "Select device vendor of network connection logs from CommonSecurityLog",
 * 						"name":           "Device vendor",
 * 						"rerun":          "RerunAlways",
 * 						"sequenceNumber": 1,
 * 						"supportedValues": []string{
 * 							"Palo Alto Networks",
 * 							"Fortinet",
 * 							"Check Point",
 * 						},
 * 						"supportedValuesKql": nil,
 * 						"value": []string{
 * 							"Palo Alto Networks",
 * 						},
 * 						"valuesKql": nil,
 * 					},
 * 				},
 * 				SingleValueObservations: nil,
 * 				ThresholdObservations: []interface{}{
 * 					map[string]interface{}{
 * 						"description":    "Suppress anomalies when daily data transfered (in MB) per hour is less than the chosen value",
 * 						"maximum":        "100",
 * 						"minimum":        "1",
 * 						"name":           "Daily data transfer threshold in MB",
 * 						"rerun":          "RerunAlways",
 * 						"sequenceNumber": 1,
 * 						"value":          "25",
 * 					},
 * 					map[string]interface{}{
 * 						"description":    "Triggers anomalies when number of standard deviations is greater than the chosen value",
 * 						"maximum":        "10",
 * 						"minimum":        "2",
 * 						"name":           "Number of standard deviations",
 * 						"rerun":          "RerunAlways",
 * 						"sequenceNumber": 2,
 * 						"value":          "3",
 * 					},
 * 				},
 * 			},
 * 			Description:       pulumi.String("When account logs from a source region that has rarely been logged in from during the last 14 days, an anomaly is triggered."),
 * 			DisplayName:       pulumi.String("Login from unusual region"),
 * 			Enabled:           pulumi.Bool(true),
 * 			Frequency:         pulumi.String("PT1H"),
 * 			IsDefaultSettings: pulumi.Bool(true),
 * 			Kind:              pulumi.String("Anomaly"),
 * 			RequiredDataConnectors: []securityinsights.SecurityMLAnalyticsSettingsDataSourceArgs{
 * 				{
 * 					ConnectorId: pulumi.String("AWS"),
 * 					DataTypes: pulumi.StringArray{
 * 						pulumi.String("AWSCloudTrail"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName:    pulumi.String("myRg"),
 * 			SettingsDefinitionId: pulumi.String("f209187f-1d17-4431-94af-c141bf5f23db"),
 * 			SettingsResourceName: pulumi.String("f209187f-1d17-4431-94af-c141bf5f23db"),
 * 			SettingsStatus:       pulumi.String("Production"),
 * 			Tactics: pulumi.StringArray{
 * 				pulumi.String("Exfiltration"),
 * 				pulumi.String("CommandAndControl"),
 * 			},
 * 			Techniques: pulumi.StringArray{
 * 				pulumi.String("T1037"),
 * 				pulumi.String("T1021"),
 * 			},
 * 			WorkspaceName: pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.AnomalySecurityMLAnalyticsSettings;
 * import com.pulumi.azurenative.securityinsights.AnomalySecurityMLAnalyticsSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var anomalySecurityMLAnalyticsSettings = new AnomalySecurityMLAnalyticsSettings("anomalySecurityMLAnalyticsSettings", AnomalySecurityMLAnalyticsSettingsArgs.builder()
 *             .anomalySettingsVersion(0)
 *             .anomalyVersion("1.0.5")
 *             .customizableObservations(Map.ofEntries(
 *                 Map.entry("multiSelectObservations", null),
 *                 Map.entry("prioritizeExcludeObservations", null),
 *                 Map.entry("singleSelectObservations", Map.ofEntries(
 *                     Map.entry("description", "Select device vendor of network connection logs from CommonSecurityLog"),
 *                     Map.entry("name", "Device vendor"),
 *                     Map.entry("rerun", "RerunAlways"),
 *                     Map.entry("sequenceNumber", 1),
 *                     Map.entry("supportedValues",
 *                         "Palo Alto Networks",
 *                         "Fortinet",
 *                         "Check Point"),
 *                     Map.entry("supportedValuesKql", null),
 *                     Map.entry("value", "Palo Alto Networks"),
 *                     Map.entry("valuesKql", null)
 *                 )),
 *                 Map.entry("singleValueObservations", null),
 *                 Map.entry("thresholdObservations",
 *                     Map.ofEntries(
 *                         Map.entry("description", "Suppress anomalies when daily data transfered (in MB) per hour is less than the chosen value"),
 *                         Map.entry("maximum", "100"),
 *                         Map.entry("minimum", "1"),
 *                         Map.entry("name", "Daily data transfer threshold in MB"),
 *                         Map.entry("rerun", "RerunAlways"),
 *                         Map.entry("sequenceNumber", 1),
 *                         Map.entry("value", "25")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("description", "Triggers anomalies when number of standard deviations is greater than the chosen value"),
 *                         Map.entry("maximum", "10"),
 *                         Map.entry("minimum", "2"),
 *                         Map.entry("name", "Number of standard deviations"),
 *                         Map.entry("rerun", "RerunAlways"),
 *                         Map.entry("sequenceNumber", 2),
 *                         Map.entry("value", "3")
 *                     ))
 *             ))
 *             .description("When account logs from a source region that has rarely been logged in from during the last 14 days, an anomaly is triggered.")
 *             .displayName("Login from unusual region")
 *             .enabled(true)
 *             .frequency("PT1H")
 *             .isDefaultSettings(true)
 *             .kind("Anomaly")
 *             .requiredDataConnectors(Map.ofEntries(
 *                 Map.entry("connectorId", "AWS"),
 *                 Map.entry("dataTypes", "AWSCloudTrail")
 *             ))
 *             .resourceGroupName("myRg")
 *             .settingsDefinitionId("f209187f-1d17-4431-94af-c141bf5f23db")
 *             .settingsResourceName("f209187f-1d17-4431-94af-c141bf5f23db")
 *             .settingsStatus("Production")
 *             .tactics(
 *                 "Exfiltration",
 *                 "CommandAndControl")
 *             .techniques(
 *                 "T1037",
 *                 "T1021")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:AnomalySecurityMLAnalyticsSettings f209187f-1d17-4431-94af-c141bf5f23db /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/securityMLAnalyticsSettings/{settingsResourceName}
 * ```
 */
public class AnomalySecurityMLAnalyticsSettings internal constructor(
    override val javaResource:
    com.pulumi.azurenative.securityinsights.AnomalySecurityMLAnalyticsSettings,
) : KotlinCustomResource(javaResource, AnomalySecurityMLAnalyticsSettingsMapper) {
    /**
     * The anomaly settings version of the Anomaly security ml analytics settings that dictates whether job version gets updated or not.
     */
    public val anomalySettingsVersion: Output<Int>?
        get() = javaResource.anomalySettingsVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The anomaly version of the AnomalySecurityMLAnalyticsSettings.
     */
    public val anomalyVersion: Output<String>
        get() = javaResource.anomalyVersion().applyValue({ args0 -> args0 })

    /**
     * The customizable observations of the AnomalySecurityMLAnalyticsSettings.
     */
    public val customizableObservations: Output<Any>?
        get() = javaResource.customizableObservations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of the SecurityMLAnalyticsSettings.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The display name for settings created by this SecurityMLAnalyticsSettings.
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * Determines whether this settings is enabled or disabled.
     */
    public val enabled: Output<Boolean>
        get() = javaResource.enabled().applyValue({ args0 -> args0 })

    /**
     * Etag of the azure resource
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The frequency that this SecurityMLAnalyticsSettings will be run.
     */
    public val frequency: Output<String>
        get() = javaResource.frequency().applyValue({ args0 -> args0 })

    /**
     * Determines whether this anomaly security ml analytics settings is a default settings
     */
    public val isDefaultSettings: Output<Boolean>
        get() = javaResource.isDefaultSettings().applyValue({ args0 -> args0 })

    /**
     * The kind of security ML analytics settings
     * Expected value is 'Anomaly'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * The last time that this SecurityMLAnalyticsSettings has been modified.
     */
    public val lastModifiedUtc: Output<String>
        get() = javaResource.lastModifiedUtc().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The required data sources for this SecurityMLAnalyticsSettings
     */
    public val requiredDataConnectors: Output<List<SecurityMLAnalyticsSettingsDataSourceResponse>>?
        get() = javaResource.requiredDataConnectors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        securityMLAnalyticsSettingsDataSourceResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The anomaly settings definition Id
     */
    public val settingsDefinitionId: Output<String>?
        get() = javaResource.settingsDefinitionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The anomaly SecurityMLAnalyticsSettings status
     */
    public val settingsStatus: Output<String>
        get() = javaResource.settingsStatus().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The tactics of the SecurityMLAnalyticsSettings
     */
    public val tactics: Output<List<String>>?
        get() = javaResource.tactics().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The techniques of the SecurityMLAnalyticsSettings
     */
    public val techniques: Output<List<String>>?
        get() = javaResource.techniques().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AnomalySecurityMLAnalyticsSettingsMapper :
    ResourceMapper<AnomalySecurityMLAnalyticsSettings> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securityinsights.AnomalySecurityMLAnalyticsSettings::class == javaResource::class

    override fun map(javaResource: Resource): AnomalySecurityMLAnalyticsSettings =
        AnomalySecurityMLAnalyticsSettings(
            javaResource as
                com.pulumi.azurenative.securityinsights.AnomalySecurityMLAnalyticsSettings,
        )
}

/**
 * @see [AnomalySecurityMLAnalyticsSettings].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AnomalySecurityMLAnalyticsSettings].
 */
public suspend fun anomalySecurityMLAnalyticsSettings(
    name: String,
    block: suspend AnomalySecurityMLAnalyticsSettingsResourceBuilder.() -> Unit,
):
    AnomalySecurityMLAnalyticsSettings {
    val builder = AnomalySecurityMLAnalyticsSettingsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AnomalySecurityMLAnalyticsSettings].
 * @param name The _unique_ name of the resulting resource.
 */
public fun anomalySecurityMLAnalyticsSettings(name: String): AnomalySecurityMLAnalyticsSettings {
    val builder = AnomalySecurityMLAnalyticsSettingsResourceBuilder()
    builder.name(name)
    return builder.build()
}
