@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.AwsCloudTrailDataConnectorArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.AwsCloudTrailDataConnectorDataTypesArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.AwsCloudTrailDataConnectorDataTypesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Represents Amazon Web Services CloudTrail data connector.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-01-01.
 * ## Example Usage
 * ### Creates or updates an Office365 data connector.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var awsCloudTrailDataConnector = new AzureNative.SecurityInsights.AwsCloudTrailDataConnector("awsCloudTrailDataConnector", new()
 *     {
 *         DataConnectorId = "73e01a99-5cd7-4139-a149-9f2736ff2ab5",
 *         ResourceGroupName = "myRg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewAwsCloudTrailDataConnector(ctx, "awsCloudTrailDataConnector", &securityinsights.AwsCloudTrailDataConnectorArgs{
 * 			DataConnectorId:   pulumi.String("73e01a99-5cd7-4139-a149-9f2736ff2ab5"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.AwsCloudTrailDataConnector;
 * import com.pulumi.azurenative.securityinsights.AwsCloudTrailDataConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awsCloudTrailDataConnector = new AwsCloudTrailDataConnector("awsCloudTrailDataConnector", AwsCloudTrailDataConnectorArgs.builder()
 *             .dataConnectorId("73e01a99-5cd7-4139-a149-9f2736ff2ab5")
 *             .resourceGroupName("myRg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or updates an Threat Intelligence Platform data connector.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var awsCloudTrailDataConnector = new AzureNative.SecurityInsights.AwsCloudTrailDataConnector("awsCloudTrailDataConnector", new()
 *     {
 *         DataConnectorId = "73e01a99-5cd7-4139-a149-9f2736ff2ab5",
 *         ResourceGroupName = "myRg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewAwsCloudTrailDataConnector(ctx, "awsCloudTrailDataConnector", &securityinsights.AwsCloudTrailDataConnectorArgs{
 * 			DataConnectorId:   pulumi.String("73e01a99-5cd7-4139-a149-9f2736ff2ab5"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.AwsCloudTrailDataConnector;
 * import com.pulumi.azurenative.securityinsights.AwsCloudTrailDataConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awsCloudTrailDataConnector = new AwsCloudTrailDataConnector("awsCloudTrailDataConnector", AwsCloudTrailDataConnectorArgs.builder()
 *             .dataConnectorId("73e01a99-5cd7-4139-a149-9f2736ff2ab5")
 *             .resourceGroupName("myRg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:AwsCloudTrailDataConnector 73e01a99-5cd7-4139-a149-9f2736ff2ab5 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/dataConnectors/{dataConnectorId}
 * ```
 * @property awsRoleArn The Aws Role Arn (with CloudTrailReadOnly policy) that is used to access the Aws account.
 * @property dataConnectorId Connector ID
 * @property dataTypes The available data types for the connector.
 * @property kind The kind of the data connector
 * Expected value is 'AmazonWebServicesCloudTrail'.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the workspace.
 */
public data class AwsCloudTrailDataConnectorArgs(
    public val awsRoleArn: Output<String>? = null,
    public val dataConnectorId: Output<String>? = null,
    public val dataTypes: Output<AwsCloudTrailDataConnectorDataTypesArgs>? = null,
    public val kind: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.AwsCloudTrailDataConnectorArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.AwsCloudTrailDataConnectorArgs =
        com.pulumi.azurenative.securityinsights.AwsCloudTrailDataConnectorArgs.builder()
            .awsRoleArn(awsRoleArn?.applyValue({ args0 -> args0 }))
            .dataConnectorId(dataConnectorId?.applyValue({ args0 -> args0 }))
            .dataTypes(dataTypes?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AwsCloudTrailDataConnectorArgs].
 */
@PulumiTagMarker
public class AwsCloudTrailDataConnectorArgsBuilder internal constructor() {
    private var awsRoleArn: Output<String>? = null

    private var dataConnectorId: Output<String>? = null

    private var dataTypes: Output<AwsCloudTrailDataConnectorDataTypesArgs>? = null

    private var kind: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The Aws Role Arn (with CloudTrailReadOnly policy) that is used to access the Aws account.
     */
    @JvmName("irlvuwchfxsrsnpm")
    public suspend fun awsRoleArn(`value`: Output<String>) {
        this.awsRoleArn = value
    }

    /**
     * @param value Connector ID
     */
    @JvmName("ymjldrixsngisubn")
    public suspend fun dataConnectorId(`value`: Output<String>) {
        this.dataConnectorId = value
    }

    /**
     * @param value The available data types for the connector.
     */
    @JvmName("ptjvqrwaefyvivcq")
    public suspend fun dataTypes(`value`: Output<AwsCloudTrailDataConnectorDataTypesArgs>) {
        this.dataTypes = value
    }

    /**
     * @param value The kind of the data connector
     * Expected value is 'AmazonWebServicesCloudTrail'.
     */
    @JvmName("varweaxobnkocnhs")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xbavwoqiegwbemry")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("bhmxmahvvdcprivf")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The Aws Role Arn (with CloudTrailReadOnly policy) that is used to access the Aws account.
     */
    @JvmName("aflgghndgmffqgkq")
    public suspend fun awsRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsRoleArn = mapped
    }

    /**
     * @param value Connector ID
     */
    @JvmName("xbqqqelseyqntjjn")
    public suspend fun dataConnectorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataConnectorId = mapped
    }

    /**
     * @param value The available data types for the connector.
     */
    @JvmName("ctfwmyfqxrhviiqw")
    public suspend fun dataTypes(`value`: AwsCloudTrailDataConnectorDataTypesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataTypes = mapped
    }

    /**
     * @param argument The available data types for the connector.
     */
    @JvmName("rxnwuoamcflfygne")
    public suspend
    fun dataTypes(argument: suspend AwsCloudTrailDataConnectorDataTypesArgsBuilder.() -> Unit) {
        val toBeMapped = AwsCloudTrailDataConnectorDataTypesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dataTypes = mapped
    }

    /**
     * @param value The kind of the data connector
     * Expected value is 'AmazonWebServicesCloudTrail'.
     */
    @JvmName("txaynwryqgyilevs")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tkobgcnrmkujkxyo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("aqirvttdjemolpkt")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): AwsCloudTrailDataConnectorArgs = AwsCloudTrailDataConnectorArgs(
        awsRoleArn = awsRoleArn,
        dataConnectorId = dataConnectorId,
        dataTypes = dataTypes,
        kind = kind,
        resourceGroupName = resourceGroupName,
        workspaceName = workspaceName,
    )
}
