@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BookmarkRelation].
 */
@PulumiTagMarker
public class BookmarkRelationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BookmarkRelationArgs = BookmarkRelationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BookmarkRelationArgsBuilder.() -> Unit) {
        val builder = BookmarkRelationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BookmarkRelation {
        val builtJavaResource =
            com.pulumi.azurenative.securityinsights.BookmarkRelation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BookmarkRelation(builtJavaResource)
    }
}

/**
 * Represents a relation between two resources
 * Azure REST API version: 2023-06-01-preview. Prior API version in Azure Native 1.x: 2019-01-01-preview.
 * Other available API versions: 2019-01-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-12-01-preview.
 * ## Example Usage
 * ### Creates or updates a bookmark relation.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bookmarkRelation = new AzureNative.SecurityInsights.BookmarkRelation("bookmarkRelation", new()
 *     {
 *         BookmarkId = "2216d0e1-91e3-4902-89fd-d2df8c535096",
 *         RelatedResourceId = "/subscriptions/d0cfe6b2-9ac0-4464-9919-dccaee2e48c0/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace/providers/Microsoft.SecurityInsights/incidents/afbd324f-6c48-459c-8710-8d1e1cd03812",
 *         RelationName = "4bb36b7b-26ff-4d1c-9cbe-0d8ab3da0014",
 *         ResourceGroupName = "myRg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewBookmarkRelation(ctx, "bookmarkRelation", &securityinsights.BookmarkRelationArgs{
 * 			BookmarkId:        pulumi.String("2216d0e1-91e3-4902-89fd-d2df8c535096"),
 * 			RelatedResourceId: pulumi.String("/subscriptions/d0cfe6b2-9ac0-4464-9919-dccaee2e48c0/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace/providers/Microsoft.SecurityInsights/incidents/afbd324f-6c48-459c-8710-8d1e1cd03812"),
 * 			RelationName:      pulumi.String("4bb36b7b-26ff-4d1c-9cbe-0d8ab3da0014"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.BookmarkRelation;
 * import com.pulumi.azurenative.securityinsights.BookmarkRelationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bookmarkRelation = new BookmarkRelation("bookmarkRelation", BookmarkRelationArgs.builder()
 *             .bookmarkId("2216d0e1-91e3-4902-89fd-d2df8c535096")
 *             .relatedResourceId("/subscriptions/d0cfe6b2-9ac0-4464-9919-dccaee2e48c0/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace/providers/Microsoft.SecurityInsights/incidents/afbd324f-6c48-459c-8710-8d1e1cd03812")
 *             .relationName("4bb36b7b-26ff-4d1c-9cbe-0d8ab3da0014")
 *             .resourceGroupName("myRg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:BookmarkRelation 4bb36b7b-26ff-4d1c-9cbe-0d8ab3da0014 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/bookmarks/{bookmarkId}/relations/{relationName}
 * ```
 */
public class BookmarkRelation internal constructor(
    override val javaResource: com.pulumi.azurenative.securityinsights.BookmarkRelation,
) : KotlinCustomResource(javaResource, BookmarkRelationMapper) {
    /**
     * Etag of the azure resource
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The resource ID of the related resource
     */
    public val relatedResourceId: Output<String>
        get() = javaResource.relatedResourceId().applyValue({ args0 -> args0 })

    /**
     * The resource kind of the related resource
     */
    public val relatedResourceKind: Output<String>
        get() = javaResource.relatedResourceKind().applyValue({ args0 -> args0 })

    /**
     * The name of the related resource
     */
    public val relatedResourceName: Output<String>
        get() = javaResource.relatedResourceName().applyValue({ args0 -> args0 })

    /**
     * The resource type of the related resource
     */
    public val relatedResourceType: Output<String>
        get() = javaResource.relatedResourceType().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object BookmarkRelationMapper : ResourceMapper<BookmarkRelation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securityinsights.BookmarkRelation::class == javaResource::class

    override fun map(javaResource: Resource): BookmarkRelation = BookmarkRelation(
        javaResource as
            com.pulumi.azurenative.securityinsights.BookmarkRelation,
    )
}

/**
 * @see [BookmarkRelation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BookmarkRelation].
 */
public suspend fun bookmarkRelation(
    name: String,
    block: suspend BookmarkRelationResourceBuilder.() -> Unit,
): BookmarkRelation {
    val builder = BookmarkRelationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BookmarkRelation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bookmarkRelation(name: String): BookmarkRelation {
    val builder = BookmarkRelationResourceBuilder()
    builder.name(name)
    return builder.build()
}
