@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataAuthorResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataCategoriesResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataDependenciesResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataSourceResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataSupportResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataAuthorResponse.Companion.toKotlin as metadataAuthorResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataCategoriesResponse.Companion.toKotlin as metadataCategoriesResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataDependenciesResponse.Companion.toKotlin as metadataDependenciesResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataSourceResponse.Companion.toKotlin as metadataSourceResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataSupportResponse.Companion.toKotlin as metadataSupportResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ContentPackage].
 */
@PulumiTagMarker
public class ContentPackageResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ContentPackageArgs = ContentPackageArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ContentPackageArgsBuilder.() -> Unit) {
        val builder = ContentPackageArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ContentPackage {
        val builtJavaResource =
            com.pulumi.azurenative.securityinsights.ContentPackage(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ContentPackage(builtJavaResource)
    }
}

/**
 * Represents a Package in Azure Security Insights.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-11-01, 2023-12-01-preview.
 * ## Example Usage
 * ### Install a package to the workspace.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var contentPackage = new AzureNative.SecurityInsights.ContentPackage("contentPackage", new()
 *     {
 *         ContentId = "str.azure-sentinel-solution-str",
 *         ContentKind = "Solution",
 *         DisplayName = "str",
 *         PackageId = "str.azure-sentinel-solution-str",
 *         ResourceGroupName = "myRg",
 *         Version = "2.0.0",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewContentPackage(ctx, "contentPackage", &securityinsights.ContentPackageArgs{
 * 			ContentId:         pulumi.String("str.azure-sentinel-solution-str"),
 * 			ContentKind:       pulumi.String("Solution"),
 * 			DisplayName:       pulumi.String("str"),
 * 			PackageId:         pulumi.String("str.azure-sentinel-solution-str"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			Version:           pulumi.String("2.0.0"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.ContentPackage;
 * import com.pulumi.azurenative.securityinsights.ContentPackageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var contentPackage = new ContentPackage("contentPackage", ContentPackageArgs.builder()
 *             .contentId("str.azure-sentinel-solution-str")
 *             .contentKind("Solution")
 *             .displayName("str")
 *             .packageId("str.azure-sentinel-solution-str")
 *             .resourceGroupName("myRg")
 *             .version("2.0.0")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:ContentPackage str.azure-sentinel-solution-str /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/contentPackages/{packageId}
 * ```
 */
public class ContentPackage internal constructor(
    override val javaResource: com.pulumi.azurenative.securityinsights.ContentPackage,
) : KotlinCustomResource(javaResource, ContentPackageMapper) {
    /**
     * The author of the package
     */
    public val author: Output<MetadataAuthorResponse>?
        get() = javaResource.author().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    metadataAuthorResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The categories of the package
     */
    public val categories: Output<MetadataCategoriesResponse>?
        get() = javaResource.categories().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    metadataCategoriesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The package id
     */
    public val contentId: Output<String>
        get() = javaResource.contentId().applyValue({ args0 -> args0 })

    /**
     * The package kind
     */
    public val contentKind: Output<String>
        get() = javaResource.contentKind().applyValue({ args0 -> args0 })

    /**
     * The version of the content schema.
     */
    public val contentSchemaVersion: Output<String>?
        get() = javaResource.contentSchemaVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The support tier of the package
     */
    public val dependencies: Output<MetadataDependenciesResponse>?
        get() = javaResource.dependencies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    metadataDependenciesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The description of the package
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The display name of the package
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * Etag of the azure resource
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * first publish date package item
     */
    public val firstPublishDate: Output<String>?
        get() = javaResource.firstPublishDate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * the icon identifier. this id can later be fetched from the content metadata
     */
    public val icon: Output<String>?
        get() = javaResource.icon().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Flag indicates if this package is among the featured list.
     */
    public val isFeatured: Output<String>?
        get() = javaResource.isFeatured().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Flag indicates if this is a newly published package.
     */
    public val isNew: Output<String>?
        get() = javaResource.isNew().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Flag indicates if this package is in preview.
     */
    public val isPreview: Output<String>?
        get() = javaResource.isPreview().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * last publish date for the package item
     */
    public val lastPublishDate: Output<String>?
        get() = javaResource.lastPublishDate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Providers for the package item
     */
    public val providers: Output<List<String>>?
        get() = javaResource.providers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The publisher display name of the package
     */
    public val publisherDisplayName: Output<String>?
        get() = javaResource.publisherDisplayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The source of the package
     */
    public val source: Output<MetadataSourceResponse>?
        get() = javaResource.source().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    metadataSourceResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The support tier of the package
     */
    public val support: Output<MetadataSupportResponse>?
        get() = javaResource.support().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    metadataSupportResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * the tactics the resource covers
     */
    public val threatAnalysisTactics: Output<List<String>>?
        get() = javaResource.threatAnalysisTactics().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * the techniques the resource covers, these have to be aligned with the tactics being used
     */
    public val threatAnalysisTechniques: Output<List<String>>?
        get() = javaResource.threatAnalysisTechniques().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * the latest version number of the package
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object ContentPackageMapper : ResourceMapper<ContentPackage> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securityinsights.ContentPackage::class == javaResource::class

    override fun map(javaResource: Resource): ContentPackage = ContentPackage(
        javaResource as
            com.pulumi.azurenative.securityinsights.ContentPackage,
    )
}

/**
 * @see [ContentPackage].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ContentPackage].
 */
public suspend fun contentPackage(
    name: String,
    block: suspend ContentPackageResourceBuilder.() -> Unit,
): ContentPackage {
    val builder = ContentPackageResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ContentPackage].
 * @param name The _unique_ name of the resulting resource.
 */
public fun contentPackage(name: String): ContentPackage {
    val builder = ContentPackageResourceBuilder()
    builder.name(name)
    return builder.build()
}
