@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.EyesOnArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Settings with single toggle.
 * Azure REST API version: 2023-06-01-preview. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * ## Example Usage
 * ### Update EyesOn settings.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eyesOn = new AzureNative.SecurityInsights.EyesOn("eyesOn", new()
 *     {
 *         Kind = "EyesOn",
 *         ResourceGroupName = "myRg",
 *         SettingsName = "EyesOn",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewEyesOn(ctx, "eyesOn", &securityinsights.EyesOnArgs{
 * 			Kind:              pulumi.String("EyesOn"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			SettingsName:      pulumi.String("EyesOn"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.EyesOn;
 * import com.pulumi.azurenative.securityinsights.EyesOnArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eyesOn = new EyesOn("eyesOn", EyesOnArgs.builder()
 *             .kind("EyesOn")
 *             .resourceGroupName("myRg")
 *             .settingsName("EyesOn")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:EyesOn EyesOn /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/settings/{settingsName}
 * ```
 * @property kind The kind of the setting
 * Expected value is 'EyesOn'.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property settingsName The setting name. Supports - Anomalies, EyesOn, EntityAnalytics, Ueba
 * @property workspaceName The name of the workspace.
 */
public data class EyesOnArgs(
    public val kind: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val settingsName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.EyesOnArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.EyesOnArgs =
        com.pulumi.azurenative.securityinsights.EyesOnArgs.builder()
            .kind(kind?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .settingsName(settingsName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EyesOnArgs].
 */
@PulumiTagMarker
public class EyesOnArgsBuilder internal constructor() {
    private var kind: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var settingsName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The kind of the setting
     * Expected value is 'EyesOn'.
     */
    @JvmName("gsahmrkrybsqnlkv")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("casfghteiiduvuto")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The setting name. Supports - Anomalies, EyesOn, EntityAnalytics, Ueba
     */
    @JvmName("nqjjkxngovpakhqx")
    public suspend fun settingsName(`value`: Output<String>) {
        this.settingsName = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("dbhcmctcswdvorsv")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The kind of the setting
     * Expected value is 'EyesOn'.
     */
    @JvmName("wpueioiuhdtkkljn")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cibkotkffnkagqdg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The setting name. Supports - Anomalies, EyesOn, EntityAnalytics, Ueba
     */
    @JvmName("faytrwvtxildvlyt")
    public suspend fun settingsName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settingsName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("dbqoqrugwwohynuj")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): EyesOnArgs = EyesOnArgs(
        kind = kind,
        resourceGroupName = resourceGroupName,
        settingsName = settingsName,
        workspaceName = workspaceName,
    )
}
