@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.FileImportArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.FileImportContentType
import com.pulumi.azurenative.securityinsights.kotlin.enums.IngestionMode
import com.pulumi.azurenative.securityinsights.kotlin.inputs.FileMetadataArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.FileMetadataArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Represents a file import in Azure Security Insights.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-12-01-preview.
 * ## Example Usage
 * ### Create a file import.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fileImport = new AzureNative.SecurityInsights.FileImport("fileImport", new()
 *     {
 *         ContentType = "StixIndicator",
 *         FileImportId = "73e01a99-5cd7-4139-a149-9f2736ff2ab5",
 *         ImportFile = new AzureNative.SecurityInsights.Inputs.FileMetadataArgs
 *         {
 *             FileFormat = "JSON",
 *             FileName = "myFile.json",
 *             FileSize = 4653,
 *         },
 *         IngestionMode = "IngestAnyValidRecords",
 *         ResourceGroupName = "myRg",
 *         Source = "mySource",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewFileImport(ctx, "fileImport", &securityinsights.FileImportArgs{
 * 			ContentType:  pulumi.String("StixIndicator"),
 * 			FileImportId: pulumi.String("73e01a99-5cd7-4139-a149-9f2736ff2ab5"),
 * 			ImportFile: &securityinsights.FileMetadataArgs{
 * 				FileFormat: pulumi.String("JSON"),
 * 				FileName:   pulumi.String("myFile.json"),
 * 				FileSize:   pulumi.Int(4653),
 * 			},
 * 			IngestionMode:     pulumi.String("IngestAnyValidRecords"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			Source:            pulumi.String("mySource"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.FileImport;
 * import com.pulumi.azurenative.securityinsights.FileImportArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fileImport = new FileImport("fileImport", FileImportArgs.builder()
 *             .contentType("StixIndicator")
 *             .fileImportId("73e01a99-5cd7-4139-a149-9f2736ff2ab5")
 *             .importFile(Map.ofEntries(
 *                 Map.entry("fileFormat", "JSON"),
 *                 Map.entry("fileName", "myFile.json"),
 *                 Map.entry("fileSize", 4653)
 *             ))
 *             .ingestionMode("IngestAnyValidRecords")
 *             .resourceGroupName("myRg")
 *             .source("mySource")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:FileImport 73e01a99-5cd7-4139-a149-9f2736ff2ab5 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/fileImports/{fileImportId}
 * ```
 * @property contentType The content type of this file.
 * @property fileImportId File import ID
 * @property importFile Represents the imported file.
 * @property ingestionMode Describes how to ingest the records in the file.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property source The source for the data in the file.
 * @property workspaceName The name of the workspace.
 */
public data class FileImportArgs(
    public val contentType: Output<Either<String, FileImportContentType>>? = null,
    public val fileImportId: Output<String>? = null,
    public val importFile: Output<FileMetadataArgs>? = null,
    public val ingestionMode: Output<Either<String, IngestionMode>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val source: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.FileImportArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.FileImportArgs =
        com.pulumi.azurenative.securityinsights.FileImportArgs.builder()
            .contentType(
                contentType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .fileImportId(fileImportId?.applyValue({ args0 -> args0 }))
            .importFile(importFile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ingestionMode(
                ingestionMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FileImportArgs].
 */
@PulumiTagMarker
public class FileImportArgsBuilder internal constructor() {
    private var contentType: Output<Either<String, FileImportContentType>>? = null

    private var fileImportId: Output<String>? = null

    private var importFile: Output<FileMetadataArgs>? = null

    private var ingestionMode: Output<Either<String, IngestionMode>>? = null

    private var resourceGroupName: Output<String>? = null

    private var source: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The content type of this file.
     */
    @JvmName("bfsaqtcmrwfqxvbl")
    public suspend fun contentType(`value`: Output<Either<String, FileImportContentType>>) {
        this.contentType = value
    }

    /**
     * @param value File import ID
     */
    @JvmName("ruxdtvmllcehauis")
    public suspend fun fileImportId(`value`: Output<String>) {
        this.fileImportId = value
    }

    /**
     * @param value Represents the imported file.
     */
    @JvmName("pfwtfpxkdfcsxqga")
    public suspend fun importFile(`value`: Output<FileMetadataArgs>) {
        this.importFile = value
    }

    /**
     * @param value Describes how to ingest the records in the file.
     */
    @JvmName("uwrgxbamlllyjkfa")
    public suspend fun ingestionMode(`value`: Output<Either<String, IngestionMode>>) {
        this.ingestionMode = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("oovatfgitjswlaah")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The source for the data in the file.
     */
    @JvmName("lxxwrarmkomtvooi")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("mcxjifnnbupvlyyl")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The content type of this file.
     */
    @JvmName("golvgysyyoxykivi")
    public suspend fun contentType(`value`: Either<String, FileImportContentType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value The content type of this file.
     */
    @JvmName("rxcwrsmkfsfjbmrl")
    public fun contentType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FileImportContentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value The content type of this file.
     */
    @JvmName("abhkyhllddfcppjf")
    public fun contentType(`value`: FileImportContentType) {
        val toBeMapped = Either.ofRight<String, FileImportContentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value File import ID
     */
    @JvmName("eclbcrrmjpbpbtmf")
    public suspend fun fileImportId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileImportId = mapped
    }

    /**
     * @param value Represents the imported file.
     */
    @JvmName("fhujsctuurgixwgd")
    public suspend fun importFile(`value`: FileMetadataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.importFile = mapped
    }

    /**
     * @param argument Represents the imported file.
     */
    @JvmName("jkurohglspgogqiy")
    public suspend fun importFile(argument: suspend FileMetadataArgsBuilder.() -> Unit) {
        val toBeMapped = FileMetadataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.importFile = mapped
    }

    /**
     * @param value Describes how to ingest the records in the file.
     */
    @JvmName("jfuakbfrilwvxrfb")
    public suspend fun ingestionMode(`value`: Either<String, IngestionMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingestionMode = mapped
    }

    /**
     * @param value Describes how to ingest the records in the file.
     */
    @JvmName("pnxllcmwbkqushjf")
    public fun ingestionMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IngestionMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ingestionMode = mapped
    }

    /**
     * @param value Describes how to ingest the records in the file.
     */
    @JvmName("qggcdymukcixnlkt")
    public fun ingestionMode(`value`: IngestionMode) {
        val toBeMapped = Either.ofRight<String, IngestionMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ingestionMode = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tqnqwnqeuwakdrqr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The source for the data in the file.
     */
    @JvmName("cggkicylxkpiqcnu")
    public suspend fun source(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("bmxctiqxehxyidav")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): FileImportArgs = FileImportArgs(
        contentType = contentType,
        fileImportId = fileImportId,
        importFile = importFile,
        ingestionMode = ingestionMode,
        resourceGroupName = resourceGroupName,
        source = source,
        workspaceName = workspaceName,
    )
}
