@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.kotlin.outputs.HuntOwnerResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.securityinsights.kotlin.outputs.HuntOwnerResponse.Companion.toKotlin as huntOwnerResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Hunt].
 */
@PulumiTagMarker
public class HuntResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HuntArgs = HuntArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HuntArgsBuilder.() -> Unit) {
        val builder = HuntArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Hunt {
        val builtJavaResource = com.pulumi.azurenative.securityinsights.Hunt(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Hunt(builtJavaResource)
    }
}

/**
 * Represents a Hunt in Azure Security Insights.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-12-01-preview.
 * ## Example Usage
 * ### Creates or updates a hunt.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hunt = new AzureNative.SecurityInsights.Hunt("hunt", new()
 *     {
 *         AttackTactics = new[]
 *         {
 *             "Reconnaissance",
 *         },
 *         AttackTechniques = new[]
 *         {
 *             "T1595",
 *         },
 *         Description = "Log4J Hunt Description",
 *         DisplayName = "Log4J new hunt",
 *         HuntId = "163e7b2a-a2ec-4041-aaba-d878a38f265f",
 *         HypothesisStatus = "Unknown",
 *         Labels = new[]
 *         {
 *             "Label1",
 *             "Label2",
 *         },
 *         Owner = new AzureNative.SecurityInsights.Inputs.HuntOwnerArgs
 *         {
 *             ObjectId = "873b5263-5d34-4149-b356-ad341b01e123",
 *         },
 *         ResourceGroupName = "myRg",
 *         Status = "New",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewHunt(ctx, "hunt", &securityinsights.HuntArgs{
 * 			AttackTactics: pulumi.StringArray{
 * 				pulumi.String("Reconnaissance"),
 * 			},
 * 			AttackTechniques: pulumi.StringArray{
 * 				pulumi.String("T1595"),
 * 			},
 * 			Description:      pulumi.String("Log4J Hunt Description"),
 * 			DisplayName:      pulumi.String("Log4J new hunt"),
 * 			HuntId:           pulumi.String("163e7b2a-a2ec-4041-aaba-d878a38f265f"),
 * 			HypothesisStatus: pulumi.String("Unknown"),
 * 			Labels: pulumi.StringArray{
 * 				pulumi.String("Label1"),
 * 				pulumi.String("Label2"),
 * 			},
 * 			Owner: &securityinsights.HuntOwnerArgs{
 * 				ObjectId: pulumi.String("873b5263-5d34-4149-b356-ad341b01e123"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			Status:            pulumi.String("New"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.Hunt;
 * import com.pulumi.azurenative.securityinsights.HuntArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hunt = new Hunt("hunt", HuntArgs.builder()
 *             .attackTactics("Reconnaissance")
 *             .attackTechniques("T1595")
 *             .description("Log4J Hunt Description")
 *             .displayName("Log4J new hunt")
 *             .huntId("163e7b2a-a2ec-4041-aaba-d878a38f265f")
 *             .hypothesisStatus("Unknown")
 *             .labels(
 *                 "Label1",
 *                 "Label2")
 *             .owner(Map.of("objectId", "873b5263-5d34-4149-b356-ad341b01e123"))
 *             .resourceGroupName("myRg")
 *             .status("New")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:Hunt 163e7b2a-a2ec-4041-aaba-d878a38f265f /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/hunts/{huntId}
 * ```
 */
public class Hunt internal constructor(
    override val javaResource: com.pulumi.azurenative.securityinsights.Hunt,
) : KotlinCustomResource(javaResource, HuntMapper) {
    /**
     * A list of mitre attack tactics the hunt is associated with
     */
    public val attackTactics: Output<List<String>>?
        get() = javaResource.attackTactics().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * A list of a mitre attack techniques the hunt is associated with
     */
    public val attackTechniques: Output<List<String>>?
        get() = javaResource.attackTechniques().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The description of the hunt
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The display name of the hunt
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * Etag of the azure resource
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The hypothesis status of the hunt.
     */
    public val hypothesisStatus: Output<String>?
        get() = javaResource.hypothesisStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of labels relevant to this hunt
     */
    public val labels: Output<List<String>>?
        get() = javaResource.labels().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Describes a user that the hunt is assigned to
     */
    public val owner: Output<HuntOwnerResponse>?
        get() = javaResource.owner().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    huntOwnerResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The status of the hunt.
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object HuntMapper : ResourceMapper<Hunt> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securityinsights.Hunt::class == javaResource::class

    override fun map(javaResource: Resource): Hunt = Hunt(
        javaResource as
            com.pulumi.azurenative.securityinsights.Hunt,
    )
}

/**
 * @see [Hunt].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Hunt].
 */
public suspend fun hunt(name: String, block: suspend HuntResourceBuilder.() -> Unit): Hunt {
    val builder = HuntResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Hunt].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hunt(name: String): Hunt {
    val builder = HuntResourceBuilder()
    builder.name(name)
    return builder.build()
}
