@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.IncidentArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.IncidentClassification
import com.pulumi.azurenative.securityinsights.kotlin.enums.IncidentClassificationReason
import com.pulumi.azurenative.securityinsights.kotlin.enums.IncidentSeverity
import com.pulumi.azurenative.securityinsights.kotlin.enums.IncidentStatus
import com.pulumi.azurenative.securityinsights.kotlin.inputs.IncidentLabelArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.IncidentLabelArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.IncidentOwnerInfoArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.IncidentOwnerInfoArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Represents an incident in Azure Security Insights.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-01-01.
 * Other available API versions: 2021-03-01-preview, 2023-02-01-preview, 2023-03-01-preview, 2023-06-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-11-01, 2023-12-01-preview.
 * ## Example Usage
 * ### Creates or updates an incident.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var incident = new AzureNative.SecurityInsights.Incident("incident", new()
 *     {
 *         Classification = "FalsePositive",
 *         ClassificationComment = "Not a malicious activity",
 *         ClassificationReason = "IncorrectAlertLogic",
 *         Description = "This is a demo incident",
 *         FirstActivityTimeUtc = "2019-01-01T13:00:30Z",
 *         IncidentId = "73e01a99-5cd7-4139-a149-9f2736ff2ab5",
 *         LastActivityTimeUtc = "2019-01-01T13:05:30Z",
 *         Owner = new AzureNative.SecurityInsights.Inputs.IncidentOwnerInfoArgs
 *         {
 *             ObjectId = "2046feea-040d-4a46-9e2b-91c2941bfa70",
 *         },
 *         ResourceGroupName = "myRg",
 *         Severity = "High",
 *         Status = "Closed",
 *         Title = "My incident",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewIncident(ctx, "incident", &securityinsights.IncidentArgs{
 * 			Classification:        pulumi.String("FalsePositive"),
 * 			ClassificationComment: pulumi.String("Not a malicious activity"),
 * 			ClassificationReason:  pulumi.String("IncorrectAlertLogic"),
 * 			Description:           pulumi.String("This is a demo incident"),
 * 			FirstActivityTimeUtc:  pulumi.String("2019-01-01T13:00:30Z"),
 * 			IncidentId:            pulumi.String("73e01a99-5cd7-4139-a149-9f2736ff2ab5"),
 * 			LastActivityTimeUtc:   pulumi.String("2019-01-01T13:05:30Z"),
 * 			Owner: &securityinsights.IncidentOwnerInfoArgs{
 * 				ObjectId: pulumi.String("2046feea-040d-4a46-9e2b-91c2941bfa70"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			Severity:          pulumi.String("High"),
 * 			Status:            pulumi.String("Closed"),
 * 			Title:             pulumi.String("My incident"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.Incident;
 * import com.pulumi.azurenative.securityinsights.IncidentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var incident = new Incident("incident", IncidentArgs.builder()
 *             .classification("FalsePositive")
 *             .classificationComment("Not a malicious activity")
 *             .classificationReason("IncorrectAlertLogic")
 *             .description("This is a demo incident")
 *             .firstActivityTimeUtc("2019-01-01T13:00:30Z")
 *             .incidentId("73e01a99-5cd7-4139-a149-9f2736ff2ab5")
 *             .lastActivityTimeUtc("2019-01-01T13:05:30Z")
 *             .owner(Map.of("objectId", "2046feea-040d-4a46-9e2b-91c2941bfa70"))
 *             .resourceGroupName("myRg")
 *             .severity("High")
 *             .status("Closed")
 *             .title("My incident")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:Incident 73e01a99-5cd7-4139-a149-9f2736ff2ab5 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/incidents/{incidentId}
 * ```
 * @property classification The reason the incident was closed
 * @property classificationComment Describes the reason the incident was closed
 * @property classificationReason The classification reason the incident was closed with
 * @property description The description of the incident
 * @property firstActivityTimeUtc The time of the first activity in the incident
 * @property incidentId Incident ID
 * @property labels List of labels relevant to this incident
 * @property lastActivityTimeUtc The time of the last activity in the incident
 * @property owner Describes a user that the incident is assigned to
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property severity The severity of the incident
 * @property status The status of the incident
 * @property title The title of the incident
 * @property workspaceName The name of the workspace.
 */
public data class IncidentArgs(
    public val classification: Output<Either<String, IncidentClassification>>? = null,
    public val classificationComment: Output<String>? = null,
    public val classificationReason: Output<Either<String, IncidentClassificationReason>>? = null,
    public val description: Output<String>? = null,
    public val firstActivityTimeUtc: Output<String>? = null,
    public val incidentId: Output<String>? = null,
    public val labels: Output<List<IncidentLabelArgs>>? = null,
    public val lastActivityTimeUtc: Output<String>? = null,
    public val owner: Output<IncidentOwnerInfoArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val severity: Output<Either<String, IncidentSeverity>>? = null,
    public val status: Output<Either<String, IncidentStatus>>? = null,
    public val title: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.IncidentArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.IncidentArgs =
        com.pulumi.azurenative.securityinsights.IncidentArgs.builder()
            .classification(
                classification?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .classificationComment(classificationComment?.applyValue({ args0 -> args0 }))
            .classificationReason(
                classificationReason?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .firstActivityTimeUtc(firstActivityTimeUtc?.applyValue({ args0 -> args0 }))
            .incidentId(incidentId?.applyValue({ args0 -> args0 }))
            .labels(labels?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .lastActivityTimeUtc(lastActivityTimeUtc?.applyValue({ args0 -> args0 }))
            .owner(owner?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .severity(
                severity?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .title(title?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IncidentArgs].
 */
@PulumiTagMarker
public class IncidentArgsBuilder internal constructor() {
    private var classification: Output<Either<String, IncidentClassification>>? = null

    private var classificationComment: Output<String>? = null

    private var classificationReason: Output<Either<String, IncidentClassificationReason>>? = null

    private var description: Output<String>? = null

    private var firstActivityTimeUtc: Output<String>? = null

    private var incidentId: Output<String>? = null

    private var labels: Output<List<IncidentLabelArgs>>? = null

    private var lastActivityTimeUtc: Output<String>? = null

    private var owner: Output<IncidentOwnerInfoArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var severity: Output<Either<String, IncidentSeverity>>? = null

    private var status: Output<Either<String, IncidentStatus>>? = null

    private var title: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The reason the incident was closed
     */
    @JvmName("jcdngocubetqbvmi")
    public suspend fun classification(`value`: Output<Either<String, IncidentClassification>>) {
        this.classification = value
    }

    /**
     * @param value Describes the reason the incident was closed
     */
    @JvmName("erwxvhvaodrpbvjf")
    public suspend fun classificationComment(`value`: Output<String>) {
        this.classificationComment = value
    }

    /**
     * @param value The classification reason the incident was closed with
     */
    @JvmName("hbaoauevbnobfaum")
    public suspend
    fun classificationReason(`value`: Output<Either<String, IncidentClassificationReason>>) {
        this.classificationReason = value
    }

    /**
     * @param value The description of the incident
     */
    @JvmName("oocvnksokjwyehuk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The time of the first activity in the incident
     */
    @JvmName("ndbffbsecgwmjlhv")
    public suspend fun firstActivityTimeUtc(`value`: Output<String>) {
        this.firstActivityTimeUtc = value
    }

    /**
     * @param value Incident ID
     */
    @JvmName("cgtnkrmowtjyamla")
    public suspend fun incidentId(`value`: Output<String>) {
        this.incidentId = value
    }

    /**
     * @param value List of labels relevant to this incident
     */
    @JvmName("myvnoiyfmnttmvck")
    public suspend fun labels(`value`: Output<List<IncidentLabelArgs>>) {
        this.labels = value
    }

    @JvmName("afgbfdgrqacejasp")
    public suspend fun labels(vararg values: Output<IncidentLabelArgs>) {
        this.labels = Output.all(values.asList())
    }

    /**
     * @param values List of labels relevant to this incident
     */
    @JvmName("kpndcdydagbdtinw")
    public suspend fun labels(values: List<Output<IncidentLabelArgs>>) {
        this.labels = Output.all(values)
    }

    /**
     * @param value The time of the last activity in the incident
     */
    @JvmName("swjrkufdmhdpefyv")
    public suspend fun lastActivityTimeUtc(`value`: Output<String>) {
        this.lastActivityTimeUtc = value
    }

    /**
     * @param value Describes a user that the incident is assigned to
     */
    @JvmName("pqxqlaemtnqplgnd")
    public suspend fun owner(`value`: Output<IncidentOwnerInfoArgs>) {
        this.owner = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tbnnpvfanocektyd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The severity of the incident
     */
    @JvmName("omnmncilpqloflcr")
    public suspend fun severity(`value`: Output<Either<String, IncidentSeverity>>) {
        this.severity = value
    }

    /**
     * @param value The status of the incident
     */
    @JvmName("kmpoamrsewjhpvbc")
    public suspend fun status(`value`: Output<Either<String, IncidentStatus>>) {
        this.status = value
    }

    /**
     * @param value The title of the incident
     */
    @JvmName("ihldayscbcwqxbnm")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("rtthjffwblkkkakr")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The reason the incident was closed
     */
    @JvmName("wjursbrihewwtyqc")
    public suspend fun classification(`value`: Either<String, IncidentClassification>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.classification = mapped
    }

    /**
     * @param value The reason the incident was closed
     */
    @JvmName("crxgikpgpuobxgts")
    public fun classification(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IncidentClassification>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.classification = mapped
    }

    /**
     * @param value The reason the incident was closed
     */
    @JvmName("vsqljjkulfymipko")
    public fun classification(`value`: IncidentClassification) {
        val toBeMapped = Either.ofRight<String, IncidentClassification>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.classification = mapped
    }

    /**
     * @param value Describes the reason the incident was closed
     */
    @JvmName("yiilrwirstgrhlrk")
    public suspend fun classificationComment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.classificationComment = mapped
    }

    /**
     * @param value The classification reason the incident was closed with
     */
    @JvmName("qmamdmopkxlrpihc")
    public suspend fun classificationReason(`value`: Either<String, IncidentClassificationReason>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.classificationReason = mapped
    }

    /**
     * @param value The classification reason the incident was closed with
     */
    @JvmName("chsbiesjxhprmidc")
    public fun classificationReason(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IncidentClassificationReason>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.classificationReason = mapped
    }

    /**
     * @param value The classification reason the incident was closed with
     */
    @JvmName("mleqbqabnsbapbny")
    public fun classificationReason(`value`: IncidentClassificationReason) {
        val toBeMapped = Either.ofRight<String, IncidentClassificationReason>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.classificationReason = mapped
    }

    /**
     * @param value The description of the incident
     */
    @JvmName("njpraatlsrnqwrol")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The time of the first activity in the incident
     */
    @JvmName("mknnxymrcuxdxnom")
    public suspend fun firstActivityTimeUtc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firstActivityTimeUtc = mapped
    }

    /**
     * @param value Incident ID
     */
    @JvmName("tydetvyrchbuemod")
    public suspend fun incidentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.incidentId = mapped
    }

    /**
     * @param value List of labels relevant to this incident
     */
    @JvmName("qbwsxdovnfcfvcqv")
    public suspend fun labels(`value`: List<IncidentLabelArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param argument List of labels relevant to this incident
     */
    @JvmName("bcehxrojegvhopjj")
    public suspend fun labels(argument: List<suspend IncidentLabelArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IncidentLabelArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.labels = mapped
    }

    /**
     * @param argument List of labels relevant to this incident
     */
    @JvmName("oacraahoxqiwolko")
    public suspend fun labels(vararg argument: suspend IncidentLabelArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            IncidentLabelArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.labels = mapped
    }

    /**
     * @param argument List of labels relevant to this incident
     */
    @JvmName("ycviuhbhltjoepau")
    public suspend fun labels(argument: suspend IncidentLabelArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IncidentLabelArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.labels = mapped
    }

    /**
     * @param values List of labels relevant to this incident
     */
    @JvmName("nhxqniffcsphcoyi")
    public suspend fun labels(vararg values: IncidentLabelArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param value The time of the last activity in the incident
     */
    @JvmName("kexhwfnxrektiyyp")
    public suspend fun lastActivityTimeUtc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastActivityTimeUtc = mapped
    }

    /**
     * @param value Describes a user that the incident is assigned to
     */
    @JvmName("rwqcavrnmsovubbw")
    public suspend fun owner(`value`: IncidentOwnerInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.owner = mapped
    }

    /**
     * @param argument Describes a user that the incident is assigned to
     */
    @JvmName("bxvqffwbsmrcmdjh")
    public suspend fun owner(argument: suspend IncidentOwnerInfoArgsBuilder.() -> Unit) {
        val toBeMapped = IncidentOwnerInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.owner = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pvnmcsrgsnbesssa")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The severity of the incident
     */
    @JvmName("mcfotgpfiikfgnbg")
    public suspend fun severity(`value`: Either<String, IncidentSeverity>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    /**
     * @param value The severity of the incident
     */
    @JvmName("sbrfgpkwcgrafbsr")
    public fun severity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IncidentSeverity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    /**
     * @param value The severity of the incident
     */
    @JvmName("qeikgfbydkoregqc")
    public fun severity(`value`: IncidentSeverity) {
        val toBeMapped = Either.ofRight<String, IncidentSeverity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    /**
     * @param value The status of the incident
     */
    @JvmName("ticqdxglpeuygups")
    public suspend fun status(`value`: Either<String, IncidentStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The status of the incident
     */
    @JvmName("klayfjqrojgsuyrt")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IncidentStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The status of the incident
     */
    @JvmName("wlfjenndplgcumqy")
    public fun status(`value`: IncidentStatus) {
        val toBeMapped = Either.ofRight<String, IncidentStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The title of the incident
     */
    @JvmName("bawotukpysomvqpp")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("fgiwfjhwackenity")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): IncidentArgs = IncidentArgs(
        classification = classification,
        classificationComment = classificationComment,
        classificationReason = classificationReason,
        description = description,
        firstActivityTimeUtc = firstActivityTimeUtc,
        incidentId = incidentId,
        labels = labels,
        lastActivityTimeUtc = lastActivityTimeUtc,
        owner = owner,
        resourceGroupName = resourceGroupName,
        severity = severity,
        status = status,
        title = title,
        workspaceName = workspaceName,
    )
}
