@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [IncidentRelation].
 */
@PulumiTagMarker
public class IncidentRelationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IncidentRelationArgs = IncidentRelationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IncidentRelationArgsBuilder.() -> Unit) {
        val builder = IncidentRelationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): IncidentRelation {
        val builtJavaResource =
            com.pulumi.azurenative.securityinsights.IncidentRelation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return IncidentRelation(builtJavaResource)
    }
}

/**
 * Represents a relation between two resources
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2021-03-01-preview, 2023-06-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-11-01, 2023-12-01-preview.
 * ## Example Usage
 * ### Creates or updates an incident relation.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var incidentRelation = new AzureNative.SecurityInsights.IncidentRelation("incidentRelation", new()
 *     {
 *         IncidentId = "afbd324f-6c48-459c-8710-8d1e1cd03812",
 *         RelatedResourceId = "/subscriptions/d0cfe6b2-9ac0-4464-9919-dccaee2e48c0/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace/providers/Microsoft.SecurityInsights/bookmarks/2216d0e1-91e3-4902-89fd-d2df8c535096",
 *         RelationName = "4bb36b7b-26ff-4d1c-9cbe-0d8ab3da0014",
 *         ResourceGroupName = "myRg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewIncidentRelation(ctx, "incidentRelation", &securityinsights.IncidentRelationArgs{
 * 			IncidentId:        pulumi.String("afbd324f-6c48-459c-8710-8d1e1cd03812"),
 * 			RelatedResourceId: pulumi.String("/subscriptions/d0cfe6b2-9ac0-4464-9919-dccaee2e48c0/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace/providers/Microsoft.SecurityInsights/bookmarks/2216d0e1-91e3-4902-89fd-d2df8c535096"),
 * 			RelationName:      pulumi.String("4bb36b7b-26ff-4d1c-9cbe-0d8ab3da0014"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.IncidentRelation;
 * import com.pulumi.azurenative.securityinsights.IncidentRelationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var incidentRelation = new IncidentRelation("incidentRelation", IncidentRelationArgs.builder()
 *             .incidentId("afbd324f-6c48-459c-8710-8d1e1cd03812")
 *             .relatedResourceId("/subscriptions/d0cfe6b2-9ac0-4464-9919-dccaee2e48c0/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace/providers/Microsoft.SecurityInsights/bookmarks/2216d0e1-91e3-4902-89fd-d2df8c535096")
 *             .relationName("4bb36b7b-26ff-4d1c-9cbe-0d8ab3da0014")
 *             .resourceGroupName("myRg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:IncidentRelation 4bb36b7b-26ff-4d1c-9cbe-0d8ab3da0014 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/incidents/{incidentId}/relations/{relationName}
 * ```
 */
public class IncidentRelation internal constructor(
    override val javaResource: com.pulumi.azurenative.securityinsights.IncidentRelation,
) : KotlinCustomResource(javaResource, IncidentRelationMapper) {
    /**
     * Etag of the azure resource
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The resource ID of the related resource
     */
    public val relatedResourceId: Output<String>
        get() = javaResource.relatedResourceId().applyValue({ args0 -> args0 })

    /**
     * The resource kind of the related resource
     */
    public val relatedResourceKind: Output<String>
        get() = javaResource.relatedResourceKind().applyValue({ args0 -> args0 })

    /**
     * The name of the related resource
     */
    public val relatedResourceName: Output<String>
        get() = javaResource.relatedResourceName().applyValue({ args0 -> args0 })

    /**
     * The resource type of the related resource
     */
    public val relatedResourceType: Output<String>
        get() = javaResource.relatedResourceType().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object IncidentRelationMapper : ResourceMapper<IncidentRelation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securityinsights.IncidentRelation::class == javaResource::class

    override fun map(javaResource: Resource): IncidentRelation = IncidentRelation(
        javaResource as
            com.pulumi.azurenative.securityinsights.IncidentRelation,
    )
}

/**
 * @see [IncidentRelation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IncidentRelation].
 */
public suspend fun incidentRelation(
    name: String,
    block: suspend IncidentRelationResourceBuilder.() -> Unit,
): IncidentRelation {
    val builder = IncidentRelationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IncidentRelation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun incidentRelation(name: String): IncidentRelation {
    val builder = IncidentRelationResourceBuilder()
    builder.name(name)
    return builder.build()
}
