@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.MicrosoftSecurityIncidentCreationAlertRuleArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.AlertSeverity
import com.pulumi.azurenative.securityinsights.kotlin.enums.MicrosoftSecurityProductName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Represents MicrosoftSecurityIncidentCreation rule.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-01-01.
 * ## Example Usage
 * ### Creates or updates a Fusion alert rule.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var microsoftSecurityIncidentCreationAlertRule = new AzureNative.SecurityInsights.MicrosoftSecurityIncidentCreationAlertRule("microsoftSecurityIncidentCreationAlertRule", new()
 *     {
 *         ResourceGroupName = "myRg",
 *         RuleId = "myFirstFusionRule",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewMicrosoftSecurityIncidentCreationAlertRule(ctx, "microsoftSecurityIncidentCreationAlertRule", &securityinsights.MicrosoftSecurityIncidentCreationAlertRuleArgs{
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			RuleId:            pulumi.String("myFirstFusionRule"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.MicrosoftSecurityIncidentCreationAlertRule;
 * import com.pulumi.azurenative.securityinsights.MicrosoftSecurityIncidentCreationAlertRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var microsoftSecurityIncidentCreationAlertRule = new MicrosoftSecurityIncidentCreationAlertRule("microsoftSecurityIncidentCreationAlertRule", MicrosoftSecurityIncidentCreationAlertRuleArgs.builder()
 *             .resourceGroupName("myRg")
 *             .ruleId("myFirstFusionRule")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or updates a MicrosoftSecurityIncidentCreation rule.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var microsoftSecurityIncidentCreationAlertRule = new AzureNative.SecurityInsights.MicrosoftSecurityIncidentCreationAlertRule("microsoftSecurityIncidentCreationAlertRule", new()
 *     {
 *         DisplayName = "testing displayname",
 *         Enabled = true,
 *         Kind = "MicrosoftSecurityIncidentCreation",
 *         ProductFilter = "Microsoft Cloud App Security",
 *         ResourceGroupName = "myRg",
 *         RuleId = "microsoftSecurityIncidentCreationRuleExample",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewMicrosoftSecurityIncidentCreationAlertRule(ctx, "microsoftSecurityIncidentCreationAlertRule", &securityinsights.MicrosoftSecurityIncidentCreationAlertRuleArgs{
 * 			DisplayName:       pulumi.String("testing displayname"),
 * 			Enabled:           pulumi.Bool(true),
 * 			Kind:              pulumi.String("MicrosoftSecurityIncidentCreation"),
 * 			ProductFilter:     pulumi.String("Microsoft Cloud App Security"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			RuleId:            pulumi.String("microsoftSecurityIncidentCreationRuleExample"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.MicrosoftSecurityIncidentCreationAlertRule;
 * import com.pulumi.azurenative.securityinsights.MicrosoftSecurityIncidentCreationAlertRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var microsoftSecurityIncidentCreationAlertRule = new MicrosoftSecurityIncidentCreationAlertRule("microsoftSecurityIncidentCreationAlertRule", MicrosoftSecurityIncidentCreationAlertRuleArgs.builder()
 *             .displayName("testing displayname")
 *             .enabled(true)
 *             .kind("MicrosoftSecurityIncidentCreation")
 *             .productFilter("Microsoft Cloud App Security")
 *             .resourceGroupName("myRg")
 *             .ruleId("microsoftSecurityIncidentCreationRuleExample")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or updates a Scheduled alert rule.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var microsoftSecurityIncidentCreationAlertRule = new AzureNative.SecurityInsights.MicrosoftSecurityIncidentCreationAlertRule("microsoftSecurityIncidentCreationAlertRule", new()
 *     {
 *         ResourceGroupName = "myRg",
 *         RuleId = "73e01a99-5cd7-4139-a149-9f2736ff2ab5",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewMicrosoftSecurityIncidentCreationAlertRule(ctx, "microsoftSecurityIncidentCreationAlertRule", &securityinsights.MicrosoftSecurityIncidentCreationAlertRuleArgs{
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			RuleId:            pulumi.String("73e01a99-5cd7-4139-a149-9f2736ff2ab5"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.MicrosoftSecurityIncidentCreationAlertRule;
 * import com.pulumi.azurenative.securityinsights.MicrosoftSecurityIncidentCreationAlertRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var microsoftSecurityIncidentCreationAlertRule = new MicrosoftSecurityIncidentCreationAlertRule("microsoftSecurityIncidentCreationAlertRule", MicrosoftSecurityIncidentCreationAlertRuleArgs.builder()
 *             .resourceGroupName("myRg")
 *             .ruleId("73e01a99-5cd7-4139-a149-9f2736ff2ab5")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:MicrosoftSecurityIncidentCreationAlertRule 73e01a99-5cd7-4139-a149-9f2736ff2ab5 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/alertRules/{ruleId}
 * ```
 * @property alertRuleTemplateName The Name of the alert rule template used to create this rule.
 * @property description The description of the alert rule.
 * @property displayName The display name for alerts created by this alert rule.
 * @property displayNamesExcludeFilter the alerts' displayNames on which the cases will not be generated
 * @property displayNamesFilter the alerts' displayNames on which the cases will be generated
 * @property enabled Determines whether this alert rule is enabled or disabled.
 * @property kind The kind of the alert rule
 * Expected value is 'MicrosoftSecurityIncidentCreation'.
 * @property productFilter The alerts' productName on which the cases will be generated
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property ruleId Alert rule ID
 * @property severitiesFilter the alerts' severities on which the cases will be generated
 * @property workspaceName The name of the workspace.
 */
public data class MicrosoftSecurityIncidentCreationAlertRuleArgs(
    public val alertRuleTemplateName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val displayNamesExcludeFilter: Output<List<String>>? = null,
    public val displayNamesFilter: Output<List<String>>? = null,
    public val enabled: Output<Boolean>? = null,
    public val kind: Output<String>? = null,
    public val productFilter: Output<Either<String, MicrosoftSecurityProductName>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val ruleId: Output<String>? = null,
    public val severitiesFilter: Output<List<Either<String, AlertSeverity>>>? = null,
    public val workspaceName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.MicrosoftSecurityIncidentCreationAlertRuleArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.MicrosoftSecurityIncidentCreationAlertRuleArgs =
        com.pulumi.azurenative.securityinsights.MicrosoftSecurityIncidentCreationAlertRuleArgs.builder()
            .alertRuleTemplateName(alertRuleTemplateName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .displayNamesExcludeFilter(
                displayNamesExcludeFilter?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .displayNamesFilter(displayNamesFilter?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .productFilter(
                productFilter?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .ruleId(ruleId?.applyValue({ args0 -> args0 }))
            .severitiesFilter(
                severitiesFilter?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MicrosoftSecurityIncidentCreationAlertRuleArgs].
 */
@PulumiTagMarker
public class MicrosoftSecurityIncidentCreationAlertRuleArgsBuilder internal constructor() {
    private var alertRuleTemplateName: Output<String>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var displayNamesExcludeFilter: Output<List<String>>? = null

    private var displayNamesFilter: Output<List<String>>? = null

    private var enabled: Output<Boolean>? = null

    private var kind: Output<String>? = null

    private var productFilter: Output<Either<String, MicrosoftSecurityProductName>>? = null

    private var resourceGroupName: Output<String>? = null

    private var ruleId: Output<String>? = null

    private var severitiesFilter: Output<List<Either<String, AlertSeverity>>>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The Name of the alert rule template used to create this rule.
     */
    @JvmName("tiykhuemsmyndkcs")
    public suspend fun alertRuleTemplateName(`value`: Output<String>) {
        this.alertRuleTemplateName = value
    }

    /**
     * @param value The description of the alert rule.
     */
    @JvmName("enrucjpxkiobyafx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The display name for alerts created by this alert rule.
     */
    @JvmName("itbuwpnefbopivhm")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value the alerts' displayNames on which the cases will not be generated
     */
    @JvmName("yxsbnqygnpftoncc")
    public suspend fun displayNamesExcludeFilter(`value`: Output<List<String>>) {
        this.displayNamesExcludeFilter = value
    }

    @JvmName("efpijnrhwvfcoxee")
    public suspend fun displayNamesExcludeFilter(vararg values: Output<String>) {
        this.displayNamesExcludeFilter = Output.all(values.asList())
    }

    /**
     * @param values the alerts' displayNames on which the cases will not be generated
     */
    @JvmName("xokqxqsbfjuqhsfp")
    public suspend fun displayNamesExcludeFilter(values: List<Output<String>>) {
        this.displayNamesExcludeFilter = Output.all(values)
    }

    /**
     * @param value the alerts' displayNames on which the cases will be generated
     */
    @JvmName("emwapcldnusbqjea")
    public suspend fun displayNamesFilter(`value`: Output<List<String>>) {
        this.displayNamesFilter = value
    }

    @JvmName("pmiixaxymxhweqrv")
    public suspend fun displayNamesFilter(vararg values: Output<String>) {
        this.displayNamesFilter = Output.all(values.asList())
    }

    /**
     * @param values the alerts' displayNames on which the cases will be generated
     */
    @JvmName("bfaehhnbciwoqhff")
    public suspend fun displayNamesFilter(values: List<Output<String>>) {
        this.displayNamesFilter = Output.all(values)
    }

    /**
     * @param value Determines whether this alert rule is enabled or disabled.
     */
    @JvmName("jeoghegvuybkxmmd")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The kind of the alert rule
     * Expected value is 'MicrosoftSecurityIncidentCreation'.
     */
    @JvmName("sqfcwsylawderqds")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The alerts' productName on which the cases will be generated
     */
    @JvmName("djrvqkjdycnjwndi")
    public suspend fun productFilter(`value`: Output<Either<String, MicrosoftSecurityProductName>>) {
        this.productFilter = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("swqgeeagqkyijixa")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Alert rule ID
     */
    @JvmName("ljptsemvgiitwamd")
    public suspend fun ruleId(`value`: Output<String>) {
        this.ruleId = value
    }

    /**
     * @param value the alerts' severities on which the cases will be generated
     */
    @JvmName("btknhgvjspbpheoc")
    public suspend fun severitiesFilter(`value`: Output<List<Either<String, AlertSeverity>>>) {
        this.severitiesFilter = value
    }

    @JvmName("vueuweirwbwlfnrb")
    public suspend fun severitiesFilter(vararg values: Output<Either<String, AlertSeverity>>) {
        this.severitiesFilter = Output.all(values.asList())
    }

    /**
     * @param values the alerts' severities on which the cases will be generated
     */
    @JvmName("budmvujdlhpuvimc")
    public suspend fun severitiesFilter(values: List<Output<Either<String, AlertSeverity>>>) {
        this.severitiesFilter = Output.all(values)
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("mjptwbfgrdgwvbke")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The Name of the alert rule template used to create this rule.
     */
    @JvmName("lpdsxflrbpcbwyql")
    public suspend fun alertRuleTemplateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alertRuleTemplateName = mapped
    }

    /**
     * @param value The description of the alert rule.
     */
    @JvmName("irjoofjsowtowtxt")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The display name for alerts created by this alert rule.
     */
    @JvmName("aucrdajlhfbtyirw")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value the alerts' displayNames on which the cases will not be generated
     */
    @JvmName("pxgcdumypwigtmiu")
    public suspend fun displayNamesExcludeFilter(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayNamesExcludeFilter = mapped
    }

    /**
     * @param values the alerts' displayNames on which the cases will not be generated
     */
    @JvmName("htvqtlxxtmhcrkbc")
    public suspend fun displayNamesExcludeFilter(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.displayNamesExcludeFilter = mapped
    }

    /**
     * @param value the alerts' displayNames on which the cases will be generated
     */
    @JvmName("gjpncipwrfbvggim")
    public suspend fun displayNamesFilter(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayNamesFilter = mapped
    }

    /**
     * @param values the alerts' displayNames on which the cases will be generated
     */
    @JvmName("mrrbaguktpwmpmyx")
    public suspend fun displayNamesFilter(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.displayNamesFilter = mapped
    }

    /**
     * @param value Determines whether this alert rule is enabled or disabled.
     */
    @JvmName("jqmyrrjsbgqlssmt")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The kind of the alert rule
     * Expected value is 'MicrosoftSecurityIncidentCreation'.
     */
    @JvmName("imtrvbwnwvyjmqit")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The alerts' productName on which the cases will be generated
     */
    @JvmName("dstvupkpihsctsks")
    public suspend fun productFilter(`value`: Either<String, MicrosoftSecurityProductName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productFilter = mapped
    }

    /**
     * @param value The alerts' productName on which the cases will be generated
     */
    @JvmName("idplvbgukiopxwro")
    public fun productFilter(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MicrosoftSecurityProductName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.productFilter = mapped
    }

    /**
     * @param value The alerts' productName on which the cases will be generated
     */
    @JvmName("lddmhvxmqypqpnag")
    public fun productFilter(`value`: MicrosoftSecurityProductName) {
        val toBeMapped = Either.ofRight<String, MicrosoftSecurityProductName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.productFilter = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tjsttmordxngobby")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Alert rule ID
     */
    @JvmName("nyvtvxqfmpaikcbm")
    public suspend fun ruleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleId = mapped
    }

    /**
     * @param value the alerts' severities on which the cases will be generated
     */
    @JvmName("cymmjobqhjvevqby")
    public suspend fun severitiesFilter(`value`: List<Either<String, AlertSeverity>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.severitiesFilter = mapped
    }

    /**
     * @param values the alerts' severities on which the cases will be generated
     */
    @JvmName("cjdcyesnmkjqloxm")
    public suspend fun severitiesFilter(vararg values: Either<String, AlertSeverity>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.severitiesFilter = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("lyucjafacdqermxg")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): MicrosoftSecurityIncidentCreationAlertRuleArgs =
        MicrosoftSecurityIncidentCreationAlertRuleArgs(
            alertRuleTemplateName = alertRuleTemplateName,
            description = description,
            displayName = displayName,
            displayNamesExcludeFilter = displayNamesExcludeFilter,
            displayNamesFilter = displayNamesFilter,
            enabled = enabled,
            kind = kind,
            productFilter = productFilter,
            resourceGroupName = resourceGroupName,
            ruleId = ruleId,
            severitiesFilter = severitiesFilter,
            workspaceName = workspaceName,
        )
}
