@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ThreatIntelligenceIndicator].
 */
@PulumiTagMarker
public class ThreatIntelligenceIndicatorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ThreatIntelligenceIndicatorArgs = ThreatIntelligenceIndicatorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ThreatIntelligenceIndicatorArgsBuilder.() -> Unit) {
        val builder = ThreatIntelligenceIndicatorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ThreatIntelligenceIndicator {
        val builtJavaResource =
            com.pulumi.azurenative.securityinsights.ThreatIntelligenceIndicator(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ThreatIntelligenceIndicator(builtJavaResource)
    }
}

/**
 * Threat intelligence information object.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2019-01-01-preview.
 * Other available API versions: 2021-04-01, 2021-09-01-preview, 2023-06-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-11-01, 2023-12-01-preview.
 * ## Example Usage
 * ### Update a threat Intelligence indicator
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var threatIntelligenceIndicator = new AzureNative.SecurityInsights.ThreatIntelligenceIndicator("threatIntelligenceIndicator", new()
 *     {
 *         Confidence = 78,
 *         CreatedByRef = "contoso@contoso.com",
 *         Description = "debugging indicators",
 *         DisplayName = "new schema",
 *         ExternalReferences = new[] {},
 *         GranularMarkings = new[] {},
 *         KillChainPhases = new[] {},
 *         Kind = "indicator",
 *         Labels = new[] {},
 *         Modified = "",
 *         Name = "d9cd6f0b-96b9-3984-17cd-a779d1e15a93",
 *         Pattern = "[url:value = 'https://www.contoso.com']",
 *         PatternType = "url",
 *         ResourceGroupName = "myRg",
 *         Revoked = false,
 *         Source = "Azure Sentinel",
 *         ThreatIntelligenceTags = new[]
 *         {
 *             "new schema",
 *         },
 *         ThreatTypes = new[]
 *         {
 *             "compromised",
 *         },
 *         ValidFrom = "2020-04-15T17:44:00.114052Z",
 *         ValidUntil = "",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewThreatIntelligenceIndicator(ctx, "threatIntelligenceIndicator", &securityinsights.ThreatIntelligenceIndicatorArgs{
 * 			Confidence:         pulumi.Int(78),
 * 			CreatedByRef:       pulumi.String("contoso@contoso.com"),
 * 			Description:        pulumi.String("debugging indicators"),
 * 			DisplayName:        pulumi.String("new schema"),
 * 			ExternalReferences: securityinsights.ThreatIntelligenceExternalReferenceArray{},
 * 			GranularMarkings:   securityinsights.ThreatIntelligenceGranularMarkingModelArray{},
 * 			KillChainPhases:    securityinsights.ThreatIntelligenceKillChainPhaseArray{},
 * 			Kind:               pulumi.String("indicator"),
 * 			Labels:             pulumi.StringArray{},
 * 			Modified:           pulumi.String(""),
 * 			Name:               pulumi.String("d9cd6f0b-96b9-3984-17cd-a779d1e15a93"),
 * 			Pattern:            pulumi.String("[url:value = 'https://www.contoso.com']"),
 * 			PatternType:        pulumi.String("url"),
 * 			ResourceGroupName:  pulumi.String("myRg"),
 * 			Revoked:            pulumi.Bool(false),
 * 			Source:             pulumi.String("Azure Sentinel"),
 * 			ThreatIntelligenceTags: pulumi.StringArray{
 * 				pulumi.String("new schema"),
 * 			},
 * 			ThreatTypes: pulumi.StringArray{
 * 				pulumi.String("compromised"),
 * 			},
 * 			ValidFrom:     pulumi.String("2020-04-15T17:44:00.114052Z"),
 * 			ValidUntil:    pulumi.String(""),
 * 			WorkspaceName: pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.ThreatIntelligenceIndicator;
 * import com.pulumi.azurenative.securityinsights.ThreatIntelligenceIndicatorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var threatIntelligenceIndicator = new ThreatIntelligenceIndicator("threatIntelligenceIndicator", ThreatIntelligenceIndicatorArgs.builder()
 *             .confidence(78)
 *             .createdByRef("contoso@contoso.com")
 *             .description("debugging indicators")
 *             .displayName("new schema")
 *             .externalReferences()
 *             .granularMarkings()
 *             .killChainPhases()
 *             .kind("indicator")
 *             .labels()
 *             .modified("")
 *             .name("d9cd6f0b-96b9-3984-17cd-a779d1e15a93")
 *             .pattern("[url:value = 'https://www.contoso.com']")
 *             .patternType("url")
 *             .resourceGroupName("myRg")
 *             .revoked(false)
 *             .source("Azure Sentinel")
 *             .threatIntelligenceTags("new schema")
 *             .threatTypes("compromised")
 *             .validFrom("2020-04-15T17:44:00.114052Z")
 *             .validUntil("")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:ThreatIntelligenceIndicator 180105c7-a28d-b1a2-4a78-234f6ec80fd6 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/threatIntelligence/main/indicators/{name}
 * ```
 */
public class ThreatIntelligenceIndicator internal constructor(
    override val javaResource: com.pulumi.azurenative.securityinsights.ThreatIntelligenceIndicator,
) : KotlinCustomResource(javaResource, ThreatIntelligenceIndicatorMapper) {
    /**
     * Etag of the azure resource
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The kind of the entity.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ThreatIntelligenceIndicatorMapper : ResourceMapper<ThreatIntelligenceIndicator> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securityinsights.ThreatIntelligenceIndicator::class == javaResource::class

    override fun map(javaResource: Resource): ThreatIntelligenceIndicator =
        ThreatIntelligenceIndicator(
            javaResource as
                com.pulumi.azurenative.securityinsights.ThreatIntelligenceIndicator,
        )
}

/**
 * @see [ThreatIntelligenceIndicator].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ThreatIntelligenceIndicator].
 */
public suspend fun threatIntelligenceIndicator(
    name: String,
    block: suspend ThreatIntelligenceIndicatorResourceBuilder.() -> Unit,
):
    ThreatIntelligenceIndicator {
    val builder = ThreatIntelligenceIndicatorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ThreatIntelligenceIndicator].
 * @param name The _unique_ name of the resulting resource.
 */
public fun threatIntelligenceIndicator(name: String): ThreatIntelligenceIndicator {
    val builder = ThreatIntelligenceIndicatorResourceBuilder()
    builder.name(name)
    return builder.build()
}
