@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.WatchlistArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.Source
import com.pulumi.azurenative.securityinsights.kotlin.inputs.WatchlistUserInfoArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.WatchlistUserInfoArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Represents a Watchlist in Azure Security Insights.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2019-01-01-preview, 2021-03-01-preview, 2021-04-01, 2021-10-01-preview, 2022-01-01-preview, 2023-06-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-11-01, 2023-12-01-preview.
 * ## Example Usage
 * ### Create or update a watchlist and bulk creates watchlist items.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var watchlist = new AzureNative.SecurityInsights.Watchlist("watchlist", new()
 *     {
 *         ContentType = "text/csv",
 *         Description = "Watchlist from CSV content",
 *         DisplayName = "High Value Assets Watchlist",
 *         ItemsSearchKey = "header1",
 *         NumberOfLinesToSkip = 1,
 *         Provider = "Microsoft",
 *         RawContent = @"This line will be skipped
 * header1,header2
 * value1,value2",
 *         ResourceGroupName = "myRg",
 *         Source = "Local file",
 *         WatchlistAlias = "highValueAsset",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewWatchlist(ctx, "watchlist", &securityinsights.WatchlistArgs{
 * 			ContentType:         pulumi.String("text/csv"),
 * 			Description:         pulumi.String("Watchlist from CSV content"),
 * 			DisplayName:         pulumi.String("High Value Assets Watchlist"),
 * 			ItemsSearchKey:      pulumi.String("header1"),
 * 			NumberOfLinesToSkip: pulumi.Int(1),
 * 			Provider:            pulumi.String("Microsoft"),
 * 			RawContent:          pulumi.String("This line will be skipped\nheader1,header2\nvalue1,value2"),
 * 			ResourceGroupName:   pulumi.String("myRg"),
 * 			Source:              pulumi.String("Local file"),
 * 			WatchlistAlias:      pulumi.String("highValueAsset"),
 * 			WorkspaceName:       pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.Watchlist;
 * import com.pulumi.azurenative.securityinsights.WatchlistArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var watchlist = new Watchlist("watchlist", WatchlistArgs.builder()
 *             .contentType("text/csv")
 *             .description("Watchlist from CSV content")
 *             .displayName("High Value Assets Watchlist")
 *             .itemsSearchKey("header1")
 *             .numberOfLinesToSkip(1)
 *             .provider("Microsoft")
 *             .rawContent("""
 * This line will be skipped
 * header1,header2
 * value1,value2            """)
 *             .resourceGroupName("myRg")
 *             .source("Local file")
 *             .watchlistAlias("highValueAsset")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a watchlist.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var watchlist = new AzureNative.SecurityInsights.Watchlist("watchlist", new()
 *     {
 *         Description = "Watchlist from CSV content",
 *         DisplayName = "High Value Assets Watchlist",
 *         ItemsSearchKey = "header1",
 *         Provider = "Microsoft",
 *         ResourceGroupName = "myRg",
 *         Source = "Local file",
 *         WatchlistAlias = "highValueAsset",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewWatchlist(ctx, "watchlist", &securityinsights.WatchlistArgs{
 * 			Description:       pulumi.String("Watchlist from CSV content"),
 * 			DisplayName:       pulumi.String("High Value Assets Watchlist"),
 * 			ItemsSearchKey:    pulumi.String("header1"),
 * 			Provider:          pulumi.String("Microsoft"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			Source:            pulumi.String("Local file"),
 * 			WatchlistAlias:    pulumi.String("highValueAsset"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.Watchlist;
 * import com.pulumi.azurenative.securityinsights.WatchlistArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var watchlist = new Watchlist("watchlist", WatchlistArgs.builder()
 *             .description("Watchlist from CSV content")
 *             .displayName("High Value Assets Watchlist")
 *             .itemsSearchKey("header1")
 *             .provider("Microsoft")
 *             .resourceGroupName("myRg")
 *             .source("Local file")
 *             .watchlistAlias("highValueAsset")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:Watchlist highValueAsset /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/watchlists/{watchlistAlias}
 * ```
 * @property contentType The content type of the raw content. For now, only text/csv is valid
 * @property created The time the watchlist was created
 * @property createdBy Describes a user that created the watchlist
 * @property defaultDuration The default duration of a watchlist (in ISO 8601 duration format)
 * @property description A description of the watchlist
 * @property displayName The display name of the watchlist
 * @property isDeleted A flag that indicates if the watchlist is deleted or not
 * @property itemsSearchKey The search key is used to optimize query performance when using watchlists for joins with other data. For example, enable a column with IP addresses to be the designated SearchKey field, then use this field as the key field when joining to other event data by IP address.
 * @property labels List of labels relevant to this watchlist
 * @property numberOfLinesToSkip The number of lines in a csv content to skip before the header
 * @property provider The provider of the watchlist
 * @property rawContent The raw content that represents to watchlist items to create. Example : This line will be skipped
 * header1,header2
 * value1,value2
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property source The source of the watchlist
 * @property tenantId The tenantId where the watchlist belongs to
 * @property updated The last time the watchlist was updated
 * @property updatedBy Describes a user that updated the watchlist
 * @property uploadStatus The status of the Watchlist upload : New, InProgress or Complete. **Note** : When a Watchlist upload status is InProgress, the Watchlist cannot be deleted
 * @property watchlistAlias The alias of the watchlist
 * @property watchlistId The id (a Guid) of the watchlist
 * @property watchlistType The type of the watchlist
 * @property workspaceName The name of the workspace.
 */
public data class WatchlistArgs(
    public val contentType: Output<String>? = null,
    public val created: Output<String>? = null,
    public val createdBy: Output<WatchlistUserInfoArgs>? = null,
    public val defaultDuration: Output<String>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val isDeleted: Output<Boolean>? = null,
    public val itemsSearchKey: Output<String>? = null,
    public val labels: Output<List<String>>? = null,
    public val numberOfLinesToSkip: Output<Int>? = null,
    public val provider: Output<String>? = null,
    public val rawContent: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val source: Output<Either<String, Source>>? = null,
    public val tenantId: Output<String>? = null,
    public val updated: Output<String>? = null,
    public val updatedBy: Output<WatchlistUserInfoArgs>? = null,
    public val uploadStatus: Output<String>? = null,
    public val watchlistAlias: Output<String>? = null,
    public val watchlistId: Output<String>? = null,
    public val watchlistType: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.WatchlistArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.WatchlistArgs =
        com.pulumi.azurenative.securityinsights.WatchlistArgs.builder()
            .contentType(contentType?.applyValue({ args0 -> args0 }))
            .created(created?.applyValue({ args0 -> args0 }))
            .createdBy(createdBy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .defaultDuration(defaultDuration?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .isDeleted(isDeleted?.applyValue({ args0 -> args0 }))
            .itemsSearchKey(itemsSearchKey?.applyValue({ args0 -> args0 }))
            .labels(labels?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .numberOfLinesToSkip(numberOfLinesToSkip?.applyValue({ args0 -> args0 }))
            .provider(provider?.applyValue({ args0 -> args0 }))
            .rawContent(rawContent?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .source(
                source?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tenantId(tenantId?.applyValue({ args0 -> args0 }))
            .updated(updated?.applyValue({ args0 -> args0 }))
            .updatedBy(updatedBy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .uploadStatus(uploadStatus?.applyValue({ args0 -> args0 }))
            .watchlistAlias(watchlistAlias?.applyValue({ args0 -> args0 }))
            .watchlistId(watchlistId?.applyValue({ args0 -> args0 }))
            .watchlistType(watchlistType?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WatchlistArgs].
 */
@PulumiTagMarker
public class WatchlistArgsBuilder internal constructor() {
    private var contentType: Output<String>? = null

    private var created: Output<String>? = null

    private var createdBy: Output<WatchlistUserInfoArgs>? = null

    private var defaultDuration: Output<String>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var isDeleted: Output<Boolean>? = null

    private var itemsSearchKey: Output<String>? = null

    private var labels: Output<List<String>>? = null

    private var numberOfLinesToSkip: Output<Int>? = null

    private var provider: Output<String>? = null

    private var rawContent: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var source: Output<Either<String, Source>>? = null

    private var tenantId: Output<String>? = null

    private var updated: Output<String>? = null

    private var updatedBy: Output<WatchlistUserInfoArgs>? = null

    private var uploadStatus: Output<String>? = null

    private var watchlistAlias: Output<String>? = null

    private var watchlistId: Output<String>? = null

    private var watchlistType: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The content type of the raw content. For now, only text/csv is valid
     */
    @JvmName("ofevjagbdusfnrge")
    public suspend fun contentType(`value`: Output<String>) {
        this.contentType = value
    }

    /**
     * @param value The time the watchlist was created
     */
    @JvmName("aoldafbpwsqgpdvt")
    public suspend fun created(`value`: Output<String>) {
        this.created = value
    }

    /**
     * @param value Describes a user that created the watchlist
     */
    @JvmName("qmfplibltvesifac")
    public suspend fun createdBy(`value`: Output<WatchlistUserInfoArgs>) {
        this.createdBy = value
    }

    /**
     * @param value The default duration of a watchlist (in ISO 8601 duration format)
     */
    @JvmName("xtipdmmvtvvdeqvk")
    public suspend fun defaultDuration(`value`: Output<String>) {
        this.defaultDuration = value
    }

    /**
     * @param value A description of the watchlist
     */
    @JvmName("cclgrjdbuihcxqii")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The display name of the watchlist
     */
    @JvmName("titmkgkjjohbtdmq")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value A flag that indicates if the watchlist is deleted or not
     */
    @JvmName("lnisceundgjyavhd")
    public suspend fun isDeleted(`value`: Output<Boolean>) {
        this.isDeleted = value
    }

    /**
     * @param value The search key is used to optimize query performance when using watchlists for joins with other data. For example, enable a column with IP addresses to be the designated SearchKey field, then use this field as the key field when joining to other event data by IP address.
     */
    @JvmName("fgorlhndwnxejsrn")
    public suspend fun itemsSearchKey(`value`: Output<String>) {
        this.itemsSearchKey = value
    }

    /**
     * @param value List of labels relevant to this watchlist
     */
    @JvmName("xfdpocxmwirfygli")
    public suspend fun labels(`value`: Output<List<String>>) {
        this.labels = value
    }

    @JvmName("ygslbochnnwbtqen")
    public suspend fun labels(vararg values: Output<String>) {
        this.labels = Output.all(values.asList())
    }

    /**
     * @param values List of labels relevant to this watchlist
     */
    @JvmName("nefnxvlytnkdawxd")
    public suspend fun labels(values: List<Output<String>>) {
        this.labels = Output.all(values)
    }

    /**
     * @param value The number of lines in a csv content to skip before the header
     */
    @JvmName("sftckueryosaunih")
    public suspend fun numberOfLinesToSkip(`value`: Output<Int>) {
        this.numberOfLinesToSkip = value
    }

    /**
     * @param value The provider of the watchlist
     */
    @JvmName("igurkadiqbmwcvmh")
    public suspend fun provider(`value`: Output<String>) {
        this.provider = value
    }

    /**
     * @param value The raw content that represents to watchlist items to create. Example : This line will be skipped
     * header1,header2
     * value1,value2
     */
    @JvmName("onvnxqslowmptafh")
    public suspend fun rawContent(`value`: Output<String>) {
        this.rawContent = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cqdgljshdmdaaiqd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The source of the watchlist
     */
    @JvmName("raaheoftherexhsn")
    public suspend fun source(`value`: Output<Either<String, Source>>) {
        this.source = value
    }

    /**
     * @param value The tenantId where the watchlist belongs to
     */
    @JvmName("mjxfarfuhqhasjsx")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value The last time the watchlist was updated
     */
    @JvmName("nbprfvdiiosgqrrm")
    public suspend fun updated(`value`: Output<String>) {
        this.updated = value
    }

    /**
     * @param value Describes a user that updated the watchlist
     */
    @JvmName("wdkkxxdjplokdvje")
    public suspend fun updatedBy(`value`: Output<WatchlistUserInfoArgs>) {
        this.updatedBy = value
    }

    /**
     * @param value The status of the Watchlist upload : New, InProgress or Complete. **Note** : When a Watchlist upload status is InProgress, the Watchlist cannot be deleted
     */
    @JvmName("mrgqvuexkhoisfxc")
    public suspend fun uploadStatus(`value`: Output<String>) {
        this.uploadStatus = value
    }

    /**
     * @param value The alias of the watchlist
     */
    @JvmName("kapcqhqxhriwofmr")
    public suspend fun watchlistAlias(`value`: Output<String>) {
        this.watchlistAlias = value
    }

    /**
     * @param value The id (a Guid) of the watchlist
     */
    @JvmName("dracurlekxaalxgo")
    public suspend fun watchlistId(`value`: Output<String>) {
        this.watchlistId = value
    }

    /**
     * @param value The type of the watchlist
     */
    @JvmName("cnitkoykhwpotyfa")
    public suspend fun watchlistType(`value`: Output<String>) {
        this.watchlistType = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("qgrwvqamfkwpqwop")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The content type of the raw content. For now, only text/csv is valid
     */
    @JvmName("olejdxlfmttgerou")
    public suspend fun contentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value The time the watchlist was created
     */
    @JvmName("tsgekebpdmqyddee")
    public suspend fun created(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.created = mapped
    }

    /**
     * @param value Describes a user that created the watchlist
     */
    @JvmName("pockhraexmyvgybw")
    public suspend fun createdBy(`value`: WatchlistUserInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createdBy = mapped
    }

    /**
     * @param argument Describes a user that created the watchlist
     */
    @JvmName("tmcixwbbscxoukkv")
    public suspend fun createdBy(argument: suspend WatchlistUserInfoArgsBuilder.() -> Unit) {
        val toBeMapped = WatchlistUserInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.createdBy = mapped
    }

    /**
     * @param value The default duration of a watchlist (in ISO 8601 duration format)
     */
    @JvmName("ehkbnvftfjkkawpv")
    public suspend fun defaultDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultDuration = mapped
    }

    /**
     * @param value A description of the watchlist
     */
    @JvmName("gmorvvudlbeusogo")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The display name of the watchlist
     */
    @JvmName("fsiespugetixgcla")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value A flag that indicates if the watchlist is deleted or not
     */
    @JvmName("pyalvyvdoeflvycv")
    public suspend fun isDeleted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isDeleted = mapped
    }

    /**
     * @param value The search key is used to optimize query performance when using watchlists for joins with other data. For example, enable a column with IP addresses to be the designated SearchKey field, then use this field as the key field when joining to other event data by IP address.
     */
    @JvmName("ticfukjkklrhusad")
    public suspend fun itemsSearchKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.itemsSearchKey = mapped
    }

    /**
     * @param value List of labels relevant to this watchlist
     */
    @JvmName("vcqvlxfwnsyngkwl")
    public suspend fun labels(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param values List of labels relevant to this watchlist
     */
    @JvmName("xcfnekisrskaeymp")
    public suspend fun labels(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param value The number of lines in a csv content to skip before the header
     */
    @JvmName("mxvhuqlykexurtra")
    public suspend fun numberOfLinesToSkip(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberOfLinesToSkip = mapped
    }

    /**
     * @param value The provider of the watchlist
     */
    @JvmName("bilwldewssbwvfwu")
    public suspend fun provider(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provider = mapped
    }

    /**
     * @param value The raw content that represents to watchlist items to create. Example : This line will be skipped
     * header1,header2
     * value1,value2
     */
    @JvmName("kyumvtcwsodtxfvg")
    public suspend fun rawContent(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rawContent = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("doylhwgwlpjdgdvv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The source of the watchlist
     */
    @JvmName("mxexdqkcwrmwiawr")
    public suspend fun source(`value`: Either<String, Source>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value The source of the watchlist
     */
    @JvmName("fdujkytdoyntrtwu")
    public fun source(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Source>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value The source of the watchlist
     */
    @JvmName("idavjlvelyhwopgo")
    public fun source(`value`: Source) {
        val toBeMapped = Either.ofRight<String, Source>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value The tenantId where the watchlist belongs to
     */
    @JvmName("xlpervedghgbcmge")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    /**
     * @param value The last time the watchlist was updated
     */
    @JvmName("dcdwreylrdvxcxnh")
    public suspend fun updated(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.updated = mapped
    }

    /**
     * @param value Describes a user that updated the watchlist
     */
    @JvmName("phpgkvfafagvyjcs")
    public suspend fun updatedBy(`value`: WatchlistUserInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.updatedBy = mapped
    }

    /**
     * @param argument Describes a user that updated the watchlist
     */
    @JvmName("oifpocwboelpbgse")
    public suspend fun updatedBy(argument: suspend WatchlistUserInfoArgsBuilder.() -> Unit) {
        val toBeMapped = WatchlistUserInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.updatedBy = mapped
    }

    /**
     * @param value The status of the Watchlist upload : New, InProgress or Complete. **Note** : When a Watchlist upload status is InProgress, the Watchlist cannot be deleted
     */
    @JvmName("noiwvrjeofbvlsxs")
    public suspend fun uploadStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uploadStatus = mapped
    }

    /**
     * @param value The alias of the watchlist
     */
    @JvmName("bwivtyqytysxrfpc")
    public suspend fun watchlistAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.watchlistAlias = mapped
    }

    /**
     * @param value The id (a Guid) of the watchlist
     */
    @JvmName("axdpqxureljkcits")
    public suspend fun watchlistId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.watchlistId = mapped
    }

    /**
     * @param value The type of the watchlist
     */
    @JvmName("ufduhqemyvwpsbpa")
    public suspend fun watchlistType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.watchlistType = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("fmrtbtdakfjbbukl")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): WatchlistArgs = WatchlistArgs(
        contentType = contentType,
        created = created,
        createdBy = createdBy,
        defaultDuration = defaultDuration,
        description = description,
        displayName = displayName,
        isDeleted = isDeleted,
        itemsSearchKey = itemsSearchKey,
        labels = labels,
        numberOfLinesToSkip = numberOfLinesToSkip,
        provider = provider,
        rawContent = rawContent,
        resourceGroupName = resourceGroupName,
        source = source,
        tenantId = tenantId,
        updated = updated,
        updatedBy = updatedBy,
        uploadStatus = uploadStatus,
        watchlistAlias = watchlistAlias,
        watchlistId = watchlistId,
        watchlistType = watchlistType,
        workspaceName = workspaceName,
    )
}
