@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The scope on which the user should have permissions, in order to be able to create connections.
 */
public enum class ProviderPermissionsScope(
    public val javaValue: com.pulumi.azurenative.securityinsights.enums.ProviderPermissionsScope,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.enums.ProviderPermissionsScope> {
    Subscription(com.pulumi.azurenative.securityinsights.enums.ProviderPermissionsScope.Subscription),
    ResourceGroup(com.pulumi.azurenative.securityinsights.enums.ProviderPermissionsScope.ResourceGroup),
    Workspace(com.pulumi.azurenative.securityinsights.enums.ProviderPermissionsScope.Workspace),
    ;

    override fun toJava(): com.pulumi.azurenative.securityinsights.enums.ProviderPermissionsScope =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.enums.ProviderPermissionsScope):
            ProviderPermissionsScope =
            ProviderPermissionsScope.values().first { it.javaValue == javaType }
    }
}
