@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.ActivityEntityQueriesPropertiesQueryDefinitionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Activity query definitions
 * @property query The Activity query to run on a given entity
 */
public data class ActivityEntityQueriesPropertiesQueryDefinitionsArgs(
    public val query: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.ActivityEntityQueriesPropertiesQueryDefinitionsArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.inputs.ActivityEntityQueriesPropertiesQueryDefinitionsArgs =
        com.pulumi.azurenative.securityinsights.inputs.ActivityEntityQueriesPropertiesQueryDefinitionsArgs.builder()
            .query(query?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ActivityEntityQueriesPropertiesQueryDefinitionsArgs].
 */
@PulumiTagMarker
public class ActivityEntityQueriesPropertiesQueryDefinitionsArgsBuilder internal constructor() {
    private var query: Output<String>? = null

    /**
     * @param value The Activity query to run on a given entity
     */
    @JvmName("umjexfcvuinjekdx")
    public suspend fun query(`value`: Output<String>) {
        this.query = value
    }

    /**
     * @param value The Activity query to run on a given entity
     */
    @JvmName("rjqgwrkeyrdpfjao")
    public suspend fun query(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.query = mapped
    }

    internal fun build(): ActivityEntityQueriesPropertiesQueryDefinitionsArgs =
        ActivityEntityQueriesPropertiesQueryDefinitionsArgs(
            query = query,
        )
}
