@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.AutomationRulePropertyValuesChangedConditionArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.AutomationRulePropertyChangedConditionSupportedChangedType
import com.pulumi.azurenative.securityinsights.kotlin.enums.AutomationRulePropertyChangedConditionSupportedPropertyType
import com.pulumi.azurenative.securityinsights.kotlin.enums.AutomationRulePropertyConditionSupportedOperator
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property changeType
 * @property operator
 * @property propertyName
 * @property propertyValues
 */
public data class AutomationRulePropertyValuesChangedConditionArgs(
    public val changeType:
    Output<Either<String, AutomationRulePropertyChangedConditionSupportedChangedType>>? = null,
    public val `operator`: Output<Either<String, AutomationRulePropertyConditionSupportedOperator>>? =
        null,
    public val propertyName:
    Output<Either<String, AutomationRulePropertyChangedConditionSupportedPropertyType>>? = null,
    public val propertyValues: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.AutomationRulePropertyValuesChangedConditionArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.inputs.AutomationRulePropertyValuesChangedConditionArgs =
        com.pulumi.azurenative.securityinsights.inputs.AutomationRulePropertyValuesChangedConditionArgs.builder()
            .changeType(
                changeType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .`operator`(
                `operator`?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .propertyName(
                propertyName?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .propertyValues(propertyValues?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [AutomationRulePropertyValuesChangedConditionArgs].
 */
@PulumiTagMarker
public class AutomationRulePropertyValuesChangedConditionArgsBuilder internal constructor() {
    private var changeType:
        Output<Either<String, AutomationRulePropertyChangedConditionSupportedChangedType>>? = null

    private var `operator`: Output<Either<String, AutomationRulePropertyConditionSupportedOperator>>? =
        null

    private var propertyName:
        Output<Either<String, AutomationRulePropertyChangedConditionSupportedPropertyType>>? = null

    private var propertyValues: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("bqgjrqgskovcgcab")
    public suspend
    fun changeType(`value`: Output<Either<String, AutomationRulePropertyChangedConditionSupportedChangedType>>) {
        this.changeType = value
    }

    /**
     * @param value
     */
    @JvmName("lugcvxtxecrtppmk")
    public suspend
    fun `operator`(`value`: Output<Either<String, AutomationRulePropertyConditionSupportedOperator>>) {
        this.`operator` = value
    }

    /**
     * @param value
     */
    @JvmName("vftygvlifgaoekvc")
    public suspend
    fun propertyName(`value`: Output<Either<String, AutomationRulePropertyChangedConditionSupportedPropertyType>>) {
        this.propertyName = value
    }

    /**
     * @param value
     */
    @JvmName("vyqanutgqdnjkgwb")
    public suspend fun propertyValues(`value`: Output<List<String>>) {
        this.propertyValues = value
    }

    @JvmName("apmmlquhhvnjmbax")
    public suspend fun propertyValues(vararg values: Output<String>) {
        this.propertyValues = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ktimqfndgbfwscab")
    public suspend fun propertyValues(values: List<Output<String>>) {
        this.propertyValues = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("amiljmmhhyxdlgos")
    public suspend
    fun changeType(`value`: Either<String, AutomationRulePropertyChangedConditionSupportedChangedType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.changeType = mapped
    }

    /**
     * @param value
     */
    @JvmName("sihxpjbjovbhmcmu")
    public fun changeType(`value`: String) {
        val toBeMapped = Either.ofLeft<String,
            AutomationRulePropertyChangedConditionSupportedChangedType,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.changeType = mapped
    }

    /**
     * @param value
     */
    @JvmName("hahplmjnivhrpouj")
    public fun changeType(`value`: AutomationRulePropertyChangedConditionSupportedChangedType) {
        val toBeMapped = Either.ofRight<String,
            AutomationRulePropertyChangedConditionSupportedChangedType,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.changeType = mapped
    }

    /**
     * @param value
     */
    @JvmName("vortbfhdulyhxxgn")
    public suspend
    fun `operator`(`value`: Either<String, AutomationRulePropertyConditionSupportedOperator>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value
     */
    @JvmName("nnprhseokbevomym")
    public fun `operator`(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AutomationRulePropertyConditionSupportedOperator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value
     */
    @JvmName("tujcnvknlvtnwxek")
    public fun `operator`(`value`: AutomationRulePropertyConditionSupportedOperator) {
        val toBeMapped = Either.ofRight<String, AutomationRulePropertyConditionSupportedOperator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value
     */
    @JvmName("ociqajfothvebrdl")
    public suspend
    fun propertyName(`value`: Either<String, AutomationRulePropertyChangedConditionSupportedPropertyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propertyName = mapped
    }

    /**
     * @param value
     */
    @JvmName("wfpeswicpphxyvtv")
    public fun propertyName(`value`: String) {
        val toBeMapped = Either.ofLeft<String,
            AutomationRulePropertyChangedConditionSupportedPropertyType,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.propertyName = mapped
    }

    /**
     * @param value
     */
    @JvmName("nwmqxhshyjjtlgyn")
    public fun propertyName(`value`: AutomationRulePropertyChangedConditionSupportedPropertyType) {
        val toBeMapped = Either.ofRight<String,
            AutomationRulePropertyChangedConditionSupportedPropertyType,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.propertyName = mapped
    }

    /**
     * @param value
     */
    @JvmName("rxqqimglvhudoaxe")
    public suspend fun propertyValues(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propertyValues = mapped
    }

    /**
     * @param values
     */
    @JvmName("hotqmbxdgdhtpmoe")
    public suspend fun propertyValues(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.propertyValues = mapped
    }

    internal fun build(): AutomationRulePropertyValuesChangedConditionArgs =
        AutomationRulePropertyValuesChangedConditionArgs(
            changeType = changeType,
            `operator` = `operator`,
            propertyName = propertyName,
            propertyValues = propertyValues,
        )
}
