@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.ConnectorDefinitionsAvailabilityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The exposure status of the connector to the customers.
 * @property isPreview Gets or sets a value indicating whether the connector is preview.
 * @property status The exposure status of the connector to the customers. Available values are 0-4 (0=None, 1=Available, 2=FeatureFlag, 3=Internal).
 */
public data class ConnectorDefinitionsAvailabilityArgs(
    public val isPreview: Output<Boolean>? = null,
    public val status: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.ConnectorDefinitionsAvailabilityArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.inputs.ConnectorDefinitionsAvailabilityArgs =
        com.pulumi.azurenative.securityinsights.inputs.ConnectorDefinitionsAvailabilityArgs.builder()
            .isPreview(isPreview?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorDefinitionsAvailabilityArgs].
 */
@PulumiTagMarker
public class ConnectorDefinitionsAvailabilityArgsBuilder internal constructor() {
    private var isPreview: Output<Boolean>? = null

    private var status: Output<Int>? = null

    /**
     * @param value Gets or sets a value indicating whether the connector is preview.
     */
    @JvmName("cnkbmugfmrgmcfme")
    public suspend fun isPreview(`value`: Output<Boolean>) {
        this.isPreview = value
    }

    /**
     * @param value The exposure status of the connector to the customers. Available values are 0-4 (0=None, 1=Available, 2=FeatureFlag, 3=Internal).
     */
    @JvmName("stlecrirpmbfwumq")
    public suspend fun status(`value`: Output<Int>) {
        this.status = value
    }

    /**
     * @param value Gets or sets a value indicating whether the connector is preview.
     */
    @JvmName("buipwaswgnepqfpg")
    public suspend fun isPreview(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isPreview = mapped
    }

    /**
     * @param value The exposure status of the connector to the customers. Available values are 0-4 (0=None, 1=Available, 2=FeatureFlag, 3=Internal).
     */
    @JvmName("ldahrmsklmuejcjf")
    public suspend fun status(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): ConnectorDefinitionsAvailabilityArgs = ConnectorDefinitionsAvailabilityArgs(
        isPreview = isPreview,
        status = status,
    )
}
