@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.ConnectorDefinitionsPermissionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The required Permissions for the connector.
 * @property customs Gets or sets the customs permissions required for the user to create connections.
 * @property licenses Gets or sets the required licenses for the user to create connections.
 * @property resourceProvider Gets or sets the resource provider permissions required for the user to create connections.
 * @property tenant Gets or sets the required tenant permissions for the connector.
 */
public data class ConnectorDefinitionsPermissionsArgs(
    public val customs: Output<List<CustomPermissionDetailsArgs>>? = null,
    public val licenses: Output<List<String>>? = null,
    public val resourceProvider: Output<List<ConnectorDefinitionsResourceProviderArgs>>? = null,
    public val tenant: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.ConnectorDefinitionsPermissionsArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.inputs.ConnectorDefinitionsPermissionsArgs =
        com.pulumi.azurenative.securityinsights.inputs.ConnectorDefinitionsPermissionsArgs.builder()
            .customs(
                customs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .licenses(licenses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceProvider(
                resourceProvider?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tenant(tenant?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ConnectorDefinitionsPermissionsArgs].
 */
@PulumiTagMarker
public class ConnectorDefinitionsPermissionsArgsBuilder internal constructor() {
    private var customs: Output<List<CustomPermissionDetailsArgs>>? = null

    private var licenses: Output<List<String>>? = null

    private var resourceProvider: Output<List<ConnectorDefinitionsResourceProviderArgs>>? = null

    private var tenant: Output<List<String>>? = null

    /**
     * @param value Gets or sets the customs permissions required for the user to create connections.
     */
    @JvmName("kqibkqikthejskdt")
    public suspend fun customs(`value`: Output<List<CustomPermissionDetailsArgs>>) {
        this.customs = value
    }

    @JvmName("qsaqompykcbhkhyn")
    public suspend fun customs(vararg values: Output<CustomPermissionDetailsArgs>) {
        this.customs = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the customs permissions required for the user to create connections.
     */
    @JvmName("gxduontdakjaoljo")
    public suspend fun customs(values: List<Output<CustomPermissionDetailsArgs>>) {
        this.customs = Output.all(values)
    }

    /**
     * @param value Gets or sets the required licenses for the user to create connections.
     */
    @JvmName("gdlmqvxuynywfpfc")
    public suspend fun licenses(`value`: Output<List<String>>) {
        this.licenses = value
    }

    @JvmName("nadpkymodnxwsjfb")
    public suspend fun licenses(vararg values: Output<String>) {
        this.licenses = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the required licenses for the user to create connections.
     */
    @JvmName("oipffwvwxsftnfav")
    public suspend fun licenses(values: List<Output<String>>) {
        this.licenses = Output.all(values)
    }

    /**
     * @param value Gets or sets the resource provider permissions required for the user to create connections.
     */
    @JvmName("kdirtkaelnuadfcu")
    public suspend
    fun resourceProvider(`value`: Output<List<ConnectorDefinitionsResourceProviderArgs>>) {
        this.resourceProvider = value
    }

    @JvmName("ogcprakbrbpivegv")
    public suspend fun resourceProvider(
        vararg
        values: Output<ConnectorDefinitionsResourceProviderArgs>,
    ) {
        this.resourceProvider = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the resource provider permissions required for the user to create connections.
     */
    @JvmName("slkgllsdjktkpuur")
    public suspend
    fun resourceProvider(values: List<Output<ConnectorDefinitionsResourceProviderArgs>>) {
        this.resourceProvider = Output.all(values)
    }

    /**
     * @param value Gets or sets the required tenant permissions for the connector.
     */
    @JvmName("gqeovxopjmwrgmfn")
    public suspend fun tenant(`value`: Output<List<String>>) {
        this.tenant = value
    }

    @JvmName("lrtcvllksafjrqkb")
    public suspend fun tenant(vararg values: Output<String>) {
        this.tenant = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the required tenant permissions for the connector.
     */
    @JvmName("mcxjboayfthtjmpp")
    public suspend fun tenant(values: List<Output<String>>) {
        this.tenant = Output.all(values)
    }

    /**
     * @param value Gets or sets the customs permissions required for the user to create connections.
     */
    @JvmName("nkykvxlkfluqqnib")
    public suspend fun customs(`value`: List<CustomPermissionDetailsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customs = mapped
    }

    /**
     * @param argument Gets or sets the customs permissions required for the user to create connections.
     */
    @JvmName("ynmtluorhedualrn")
    public suspend
    fun customs(argument: List<suspend CustomPermissionDetailsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CustomPermissionDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customs = mapped
    }

    /**
     * @param argument Gets or sets the customs permissions required for the user to create connections.
     */
    @JvmName("sepcjgcaygaejaam")
    public suspend fun customs(
        vararg
        argument: suspend CustomPermissionDetailsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CustomPermissionDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customs = mapped
    }

    /**
     * @param argument Gets or sets the customs permissions required for the user to create connections.
     */
    @JvmName("hltbbaeanxkupfdr")
    public suspend fun customs(argument: suspend CustomPermissionDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CustomPermissionDetailsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.customs = mapped
    }

    /**
     * @param values Gets or sets the customs permissions required for the user to create connections.
     */
    @JvmName("arhunbjjgredmgrx")
    public suspend fun customs(vararg values: CustomPermissionDetailsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customs = mapped
    }

    /**
     * @param value Gets or sets the required licenses for the user to create connections.
     */
    @JvmName("qwhrkilboethmbcc")
    public suspend fun licenses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenses = mapped
    }

    /**
     * @param values Gets or sets the required licenses for the user to create connections.
     */
    @JvmName("woarjubtnmvjfixn")
    public suspend fun licenses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenses = mapped
    }

    /**
     * @param value Gets or sets the resource provider permissions required for the user to create connections.
     */
    @JvmName("sfafuoqtryelwrtr")
    public suspend fun resourceProvider(`value`: List<ConnectorDefinitionsResourceProviderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceProvider = mapped
    }

    /**
     * @param argument Gets or sets the resource provider permissions required for the user to create connections.
     */
    @JvmName("lmqlmvsivhjmqgud")
    public suspend
    fun resourceProvider(argument: List<suspend ConnectorDefinitionsResourceProviderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConnectorDefinitionsResourceProviderArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceProvider = mapped
    }

    /**
     * @param argument Gets or sets the resource provider permissions required for the user to create connections.
     */
    @JvmName("mgdemtkxapeduxxj")
    public suspend fun resourceProvider(
        vararg
        argument: suspend ConnectorDefinitionsResourceProviderArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ConnectorDefinitionsResourceProviderArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceProvider = mapped
    }

    /**
     * @param argument Gets or sets the resource provider permissions required for the user to create connections.
     */
    @JvmName("oxlpepyiheujslfg")
    public suspend
    fun resourceProvider(argument: suspend ConnectorDefinitionsResourceProviderArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ConnectorDefinitionsResourceProviderArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceProvider = mapped
    }

    /**
     * @param values Gets or sets the resource provider permissions required for the user to create connections.
     */
    @JvmName("ipweqnjlldmcjugf")
    public suspend fun resourceProvider(vararg values: ConnectorDefinitionsResourceProviderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceProvider = mapped
    }

    /**
     * @param value Gets or sets the required tenant permissions for the connector.
     */
    @JvmName("usugbyrimdckcwip")
    public suspend fun tenant(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenant = mapped
    }

    /**
     * @param values Gets or sets the required tenant permissions for the connector.
     */
    @JvmName("hissmqemfeomneog")
    public suspend fun tenant(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tenant = mapped
    }

    internal fun build(): ConnectorDefinitionsPermissionsArgs = ConnectorDefinitionsPermissionsArgs(
        customs = customs,
        licenses = licenses,
        resourceProvider = resourceProvider,
        tenant = tenant,
    )
}
